package com.cv.media.lib.common_utils;

import android.app.Application;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Trace;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.cv.media.lib.common_utils.appstat.AppManager;
import com.cv.media.lib.common_utils.keyevent.KeyEventsCenter;
import com.cv.media.lib.common_utils.laucher.DataFromLaunch;


/**
 *  * 工具类 在应用启动时 主线程初始化入口
 * 职责: 特别重要的工具类初始化, 非要在主线程的, 集中在此类 初始化
 *
 * @author Damon
 */
public class UtilsInit extends ContentProvider {
    private static Context mContext;

    @Override
    public boolean onCreate() {
        if(BuildConfig.DEBUG) {
            Log.v(UtilsInit.class.getSimpleName(), "onCreate Start");
            Trace.beginSection("UtilsInit onCreate");
        }
        mContext = getContext();
        DataFromLaunch.getInstance().init((Application) getContext());
//        Logger.init(mContext);
        AppManager.INSTANCE.init((Application) getContext());
        // BreakPad.init(getContext());
        KeyEventsCenter.init((Application) getContext());
        if (BuildConfig.DEBUG) {
//            UIBlockChecker.check(1000, new UIBlockChecker.CallBack() {
//                @Override
//                public void onBlock(String stacktrace) {
//                    Log.w("UIBlock", stacktrace);
//                }
//            });
            //MemoryMonitor.getInstance().init(getContext().getApplicationContext());
            //DoraemonKit.install(application);
        }

        if(BuildConfig.DEBUG) {
            Trace.endSection();
            Log.v(UtilsInit.class.getSimpleName(), "onCreate end");
        }
        return true;
    }


    @Nullable
    @Override
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        return null;
    }

    @Nullable
    @Override
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    @Override
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    @Override
    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }
}
