package com.cv.media.lib.common_utils.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Log;

import com.cv.media.lib.common_utils.provider.ContextProvider;
import com.cv.media.lib.hardware.device.DeviceInfo;
import com.cv.media.lib.hardware.device.HardwareManager;
import com.cv.media.lib.hardware.network.NetworkManager;
import com.leon.channel.helper.ChannelReaderUtil;

public class AppUtils {
    static String releaseType = null;
    static int versionCode = -1;
    static String versionName = "";
    static String googleChannelName = "google";

    public static String getReleaseType() {
        if (releaseType == null) {
            try {
                ApplicationInfo applicationInfo = ContextProvider.getContext().getPackageManager().getApplicationInfo(ContextProvider.getContext().getPackageName(), PackageManager.GET_META_DATA);
                releaseType = applicationInfo.metaData.getString("RELEASE_TYPE");
            } catch (Throwable e) {
                releaseType = "UNKNOWN";
            }
        }
        return releaseType;
    }

    public static int getVersionCode() {
        if (versionCode != -1) return versionCode;
        PackageManager pm = ContextProvider.getContext().getPackageManager();
        try {
            PackageInfo pi = pm.getPackageInfo(ContextProvider.getContext().getPackageName(), 0);
            versionCode = pi.versionCode;
            return versionCode;
        } catch (Exception ex) {
            Log.e(Class.class.getName(), ex.getMessage(), ex);
            return 100;
        }
    }

    public static String getVersion() {
        if (!TextUtils.isEmpty(versionName)) {
            return versionName;
        }
        PackageManager pm = ContextProvider.getContext().getPackageManager();
        try {
            PackageInfo info = pm.getPackageInfo(ContextProvider.getContext().getPackageName(), 0);
            versionName = info.versionName;
            return versionName;
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void setComponentStatus(String compName, int status) {
        ComponentName componentName = new ComponentName(ContextProvider.getContext(), compName);
        PackageManager pm = ContextProvider.getContext().getPackageManager();
        if (pm.getComponentEnabledSetting(componentName) != status) {//新状态跟当前状态不一样才执行
            pm.setComponentEnabledSetting(
                    componentName,
                    status,
                    PackageManager.DONT_KILL_APP);
        }
    }

    public static String versionCode2String(long versionCode) {
        if (versionCode <= 0) return "0.0.0";
        String tmp = "";
        String intVerStr = String.valueOf(versionCode);
        // >=10803 之后的逻辑
        if (intVerStr.length() < 8) {
            tmp = StringUtils.leftPad(intVerStr, 8, '0');
        } else {
            tmp = intVerStr;
        }
        tmp = StringUtils.right(tmp, 8);
        String normalStr = Integer.valueOf(tmp.substring(0, 2)) + "." + Integer.valueOf(tmp.substring(2, 4)) + "." + Integer.valueOf(tmp.substring(4, 6));
        int buildNo = Integer.valueOf(tmp.substring(6, 8));
        String betaStr = "";
        if (buildNo < 30) {
            betaStr = "alpha" + buildNo;
        } else if (buildNo < 66) {
            betaStr = "beta" + (buildNo - 30);
        }
        return normalStr + betaStr;
    }

    /**
     * apk渠道
     * @return
     */
    public static String getApkChannel(){
        return ChannelReaderUtil.getChannel(ContextProvider.getContext());
    }

    //aab or apk渠道
    public static String getAabOrApkChannel() {
        if (!TextUtils.isEmpty(getApkChannel())) {
            return getApkChannel();
        }
        return googleChannelName;
    }

    public static String getDeviceIdentifier() {
        String did = NetworkManager.getInstance().getMac();
        if (TextUtils.isEmpty(did) || did.equals("020000000000")) {
            // WifiInfo#getBSSID return 02:00:00:00:00:00，通过NetworkManager获取的mac就是020000000000
            // 高版本手机经测试都是返回"020000000000"，用AndroidId代替
            DeviceInfo deviceInfo = HardwareManager.getInstance().getDeviceInfo();
            if (null != deviceInfo) {
                did = deviceInfo.getAndroidId();
            }
        }
        return did;
    }
}
