package com.cv.media.lib.common_utils.utils.storage;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;

import androidx.core.content.ContextCompat;

import com.cv.media.lib.common_utils.permisson.Permission;
import com.cv.media.lib.common_utils.permisson.XXPermissions;
import com.cv.media.lib.common_utils.provider.ContextProvider;
import com.cv.media.lib.common_utils.utils.StringUtils;

import java.io.File;


/**
 * 公用目录和各个模块私有目录统一配置文件
 */
public class DirectoryUtils {

    private static String APP_ID;

    private static String SYSTEM_DIR = "/system/";

    private static String ODM_DIR = "/odm/";

    public static void init(String appId) {
        if (StringUtils.isEmpty(appId)) throw new RuntimeException("appId can't be null");
        APP_ID = appId;
    }

    public static String getSnDir() {
        return getExternalDir() + File.separator + "sn" + File.separator;
    }

    public static String getPublicDir(Context context) {
        return ContextCompat.getDataDir(context).getAbsolutePath() + File.separator + APP_ID + File.separator;
    }

    public static String getRdnsWorkDir(Context context) {
        return ContextCompat.getDataDir(context).getAbsolutePath() + File.separator + "rdns" + File.separator;
    }

    public static String getCacheDir(Context context) {
        return context.getCacheDir().getAbsolutePath() + File.separator;
    }

    public static String getScreenSaverDir(Context context) {
        return getPublicDir(context) + "screen_saver" + File.separator;
    }

    public static String getFirstScreenDir(Context context) {
        return getPublicDir(context) + "first_screen" + File.separator;
    }

    public static String getCrashLogDir(Context context) {
        return getPublicDir(context) + "crash" + File.separator;
    }

    public static String getLogDir(Context context) {
        return getPublicDir(context) + "log" + File.separator;
    }

    public static String getPurecacheDir(Context context) {
        return getPublicDir(context) + "purecache" + File.separator;
    }

    public static String getIpcDir(Context context) {
        return getPublicDir(context) + "ipc" + File.separator;
    }

    public static String getDebugDir(Context context) {
        return getPublicDir(context) + "debug" + File.separator;
    }

    public static String getImageLoaderCacheDir(Context context) {
        return getCacheDir(context) + "UniversalImageLoader" + File.separator;
    }

    public static String getOtaDir(Context context) {
        return getPublicDir(context) + "ota" + File.separator;
    }

    public static String getPlayerPickerDir(Context context) {
        return getPublicDir(context) + "playerConfig" + File.separator;
    }

    static File externalStorageDirectory;
    static Boolean isExternalStorageLegacy;
    public static String getExternalDir() {
        synchronized (DirectoryUtils.class) {
            if (isExternalStorageLegacy == null) {
                isExternalStorageLegacy = isExternalStorageLegacy();
            }

            if (isExternalStorageLegacy && externalStorageDirectory == null) {
                externalStorageDirectory = Environment.getExternalStorageDirectory();
            }
        }

        if (isExternalStorageLegacy) {
            //继续沿用旧版文件操作
            try {
                if (XXPermissions.isHasPermission(ContextProvider.getContext(), Permission.Group.STORAGE)
                        && externalStorageDirectory != null) {
                    return externalStorageDirectory.getAbsolutePath() + File.separator + APP_ID + File.separator;
                }
            } catch (Exception e) {

            }
        }
        return getExternalDir(APP_ID);
    }

    public static String getExternalDir(String dirName) {
        try {
            //有些人碰到Environment.getExternalStorageState()==Environment.MEDIA_MOUNTED,SD卡挂载，仍然会报空
            return ContextProvider.getContext().getExternalFilesDir(dirName).getAbsolutePath() + File.separator;
        } catch (Exception e) {
            return ContextProvider.getContext().getFilesDir().getAbsolutePath() + File.separator + dirName + File.separator;
        }
    }

    public static String getSystemDir() {
        return SYSTEM_DIR;
    }

    public static String getOdmDir() {
        return ODM_DIR;
    }

    public static String getMetricDir(Context context) {
        return getPublicDir(context) + "metric" + File.separator;
    }

    public static String getCloudDir(Context context) {
        return getPublicDir(context) + "cloud" + File.separator;
    }

    public static String getAppDir(Context context) {
        return ContextCompat.getDataDir(context).getAbsolutePath();
    }

    public static String getPMCacheDir(Context context) {
        return ContextCompat.getDataDir(context).getAbsolutePath() + File.separator + "pm" + File.separator + "cache" + File.separator;
    }

    public static String getPMCDNCacheDir(Context context) {
        return ContextCompat.getDataDir(context).getAbsolutePath() + File.separator + "cdn" + File.separator + "cache" + File.separator;
    }

    public static File getOwnCacheDirectory(Context context, String cacheDir) {
        File appCacheDir = null;
        if (appCacheDir == null || (!appCacheDir.exists() && !appCacheDir.mkdirs())) {
            appCacheDir = context.getCacheDir();
        }
        return appCacheDir;
    }

    private static boolean hasExternalStoragePermission(Context context) {
        int perm = context.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE");
        return perm == PackageManager.PERMISSION_GRANTED;
    }

    public static boolean isExternalStorageLegacy() {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.Q) {
            //android 10以下
            return true;
        }
        //android 10以上，外部sd卡不能用，文件存储再内部目录
        if (Environment.isExternalStorageLegacy()) {
            //继续使用老版本的方式，可以自由访问sd卡,覆盖升级，或者android10支持兼容
            return true;
        }
        return false;
    }
}
