package com.cv.media.lib.dex.api;

import android.content.Context;

import java.io.File;

import dalvik.system.DexClassLoader;

/**
 * @Author: Elegant Wang
 * @CreateDate: 2021/4/20 10:15
 * @Description:
 */
public class DexHotPlugin {
    private static ClassLoader sClassLoader;

    public static void init(Context context, String dexFilePath) {
        try {
            File dexFile = new File(dexFilePath);
            if (!dexFile.exists()) {
                return;
            }

            ClassLoader classLoader = new DexClassLoader(dexFilePath, context.getDir("dex", Context.MODE_PRIVATE).getAbsolutePath(), null, context.getClassLoader());
            sClassLoader = classLoader;
        } catch (Exception e) {
        }
    }

    public static <T> T create(final Class<T> exceptClass, String className) {
        if (sClassLoader == null) return null;
        try {
            Class newClass = sClassLoader.loadClass(className);
            T t = (T) newClass.newInstance();
            return t;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
