package com.cv.media.lib.dex.api.certi;

import android.os.Build;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SsX509TrustManager implements X509TrustManager {

    private static TrustManager[] trustManagers;
    private static final X509Certificate[] _AcceptedIssuers = new
            X509Certificate[]{};

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {

    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {

    }

    public boolean isClientTrusted(X509Certificate[] chain) {
        return true;
    }

    public boolean isServerTrusted(X509Certificate[] chain) {
        return true;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
//        return new X509Certificate[0];
        return _AcceptedIssuers;
    }

    public static SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] tm = new TrustManager[]{new SsX509TrustManager()};
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, tm, new SecureRandom());
        return context;
    }

    public static SSLSocketFactory getSSlSocketFactory() throws KeyManagementException, NoSuchAlgorithmException {
        if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.KITKAT) {
            return getTls12Factory();
        } else {
            return getSSLContext().getSocketFactory();
        }
    }

    /**
     * 解决andoird 4.4出现的sslv3异常的问题
     */
    public static void initSSLFactoryForKitkat() {
        try {
            if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.KITKAT) {
                //android
                HttpsURLConnection.setDefaultSSLSocketFactory(getTls12Factory());
                HttpsURLConnection.setDefaultHostnameVerifier(getHostNameVerifier());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SSLSocketFactory getTls12Factory() throws NoSuchAlgorithmException, KeyManagementException {
        return new Tls12SocketFactory(getSSLContext().getSocketFactory());
    }


    public static HostnameVerifier getHostNameVerifier() {
        return new HostnameVerifier() {

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                // TODO Auto-generated method stub
                return true;
            }
        };
    }


//    /**
//     * 允许所有的SSL请求，添加在new StringRequest()之前
//     */
//    public static void allowAllSSL() {
//        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier() {
//
//            @Override
//            public boolean verify(String arg0, SSLSession arg1) {
//                // TODO Auto-generated method stub
//                return true;
//            }
//
//        });
//
//        SSLContext context = null;
//        if (trustManagers == null) {
//            trustManagers = new TrustManager[]{new SsX509TrustManager()};
//        }
//
//        try {
//            context = SSLContext.getInstance("TLS");
//            context.init(null, trustManagers, new SecureRandom());
//        } catch (NoSuchAlgorithmException e) {
//            e.printStackTrace();
//        } catch (KeyManagementException e) {
//            e.printStackTrace();
//        }
//
//        HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
//    }

    public static class Tls12SocketFactory extends SSLSocketFactory {
        private final String[] TLS_SUPPORT_VERSION = {"TLSv1.2"};

        final SSLSocketFactory delegate;

        public Tls12SocketFactory(SSLSocketFactory base) {
            this.delegate = base;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return delegate.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return delegate.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return patch(delegate.createSocket(s, host, port, autoClose));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return patch(delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return patch(delegate.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return patch(delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return patch(delegate.createSocket(address, port, localAddress, localPort));
        }

        private Socket patch(Socket s) {
            if (s instanceof SSLSocket) {
                SSLSocket sslSocket = (SSLSocket) s;
                sslSocket.setEnabledProtocols(sslSocket.getSupportedProtocols());
                sslSocket.setEnabledCipherSuites(sslSocket.getSupportedCipherSuites());
            }
            return s;
        }
    }
}
