/*
 * Decompiled with CFR 0.152.
 */
package com.kezong.fataar;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AndroidArchiveLibrary {
    private final Project mProject;
    private final ResolvedArtifact mArtifact;
    private final String mVariantName;
    private String mPackageName;

    public AndroidArchiveLibrary(Project project, ResolvedArtifact artifact, String variantName) {
        if (!"aar".equals(artifact.getType())) {
            throw new IllegalArgumentException("artifact must be aar type!");
        }
        this.mProject = project;
        this.mArtifact = artifact;
        this.mVariantName = variantName;
    }

    public String getGroup() {
        return this.mArtifact.getModuleVersion().getId().getGroup();
    }

    public String getName() {
        return this.mArtifact.getModuleVersion().getId().getName();
    }

    public String getVersion() {
        return this.mArtifact.getModuleVersion().getId().getVersion();
    }

    public File getRootFolder() {
        File explodedRootDir = this.mProject.file((Object)(this.mProject.getBuildDir() + "/intermediates/exploded-aar/"));
        ModuleVersionIdentifier id = this.mArtifact.getModuleVersion().getId();
        return this.mProject.file((Object)(explodedRootDir + "/" + id.getGroup() + "/" + id.getName() + "/" + id.getVersion() + "/" + this.mVariantName));
    }

    public File getAidlFolder() {
        return new File(this.getRootFolder(), "aidl");
    }

    public File getAssetsFolder() {
        return new File(this.getRootFolder(), "assets");
    }

    public File getLibsFolder() {
        return new File(this.getRootFolder(), "libs");
    }

    public File getClassesJarFile() {
        return new File(this.getRootFolder(), "classes.jar");
    }

    public Collection<File> getLocalJars() {
        ArrayList<File> localJars = new ArrayList<File>();
        File[] jarList = this.getLibsFolder().listFiles();
        if (jarList != null) {
            for (File jars : jarList) {
                if (!jars.isFile() || !jars.getName().endsWith(".jar")) continue;
                localJars.add(jars);
            }
        }
        return localJars;
    }

    public File getJniFolder() {
        return new File(this.getRootFolder(), "jni");
    }

    public File getResFolder() {
        return new File(this.getRootFolder(), "res");
    }

    public File getManifest() {
        return new File(this.getRootFolder(), "AndroidManifest.xml");
    }

    public File getLintJar() {
        return new File(this.getRootFolder(), "lint.jar");
    }

    public File getProguardRules() {
        return new File(this.getRootFolder(), "proguard.txt");
    }

    public File getSymbolFile() {
        return new File(this.getRootFolder(), "R.txt");
    }

    public synchronized String getPackageName() {
        if (this.mPackageName == null) {
            File manifestFile = this.getManifest();
            if (manifestFile.exists()) {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    Document doc = dbf.newDocumentBuilder().parse(manifestFile);
                    Element element = doc.getDocumentElement();
                    this.mPackageName = element.getAttribute("package");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                throw new RuntimeException(this.getName() + " module's AndroidManifest not found");
            }
        }
        return this.mPackageName;
    }

    public File getDataBindingFolder() {
        return new File(this.getRootFolder(), "data-binding");
    }

    public File getDataBindingLogFolder() {
        return new File(this.getRootFolder(), "data-binding-base-class-log");
    }
}

