package com.kezong.fataar

import com.android.build.gradle.LibraryPlugin
import org.gradle.api.Project
import org.gradle.api.artifacts.Configuration
import org.gradle.api.artifacts.DependencyResolutionListener
import org.gradle.api.artifacts.DependencySet
import org.gradle.api.artifacts.ResolvableDependencies
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependency
import org.gradle.api.internal.artifacts.dependencies.DefaultSelfResolvingDependency

class EmbedResolutionListener implements DependencyResolutionListener {

    private final Project mProject

    private final Configuration configuration

    private final String compileOnlyConfigName;

    EmbedResolutionListener(Project project, Configuration configuration) {
        this.mProject = project
        this.configuration = configuration
        String prefix = getConfigNamePrefix(configuration.name)
        if (prefix != null) {
            this.compileOnlyConfigName = prefix + "CompileOnly"
        } else {
            this.compileOnlyConfigName = "compileOnly"
        }
    }

    private String getConfigNamePrefix(String configurationName) {
        if (configurationName.endsWith(FatAarPlugin.CONFIG_SUFFIX)) {
            return configurationName.substring(0, configuration.name.length() - FatAarPlugin.CONFIG_SUFFIX.length())
        } else {
            return null
        }
    }

    @Override
    void beforeResolve(ResolvableDependencies resolvableDependencies) {
        //开始处理 使用了 自己相应的configuration的 所有的依赖
        configuration.dependencies.each { dependency ->
            if (dependency instanceof DefaultProjectDependency) {
                if (dependency.targetConfiguration == null) {
                    dependency.targetConfiguration = "default"
                }
                // support that the module can be indexed in Android Studio 4.0.0
                DefaultProjectDependency dependencyClone = dependency.copy()
                dependencyClone.targetConfiguration = null;
                // The purpose is to support the code hints
                mProject.dependencies.add(compileOnlyConfigName, dependencyClone)
                dependencyClone.dependencyProject.afterEvaluate { Project pjt ->
                    List<String> configurations = ['implementation', 'api']
                    def projectsExclude = []
                    configuration.dependencies.each {
                        if (it instanceof DefaultProjectDependency) {
                            projectsExclude.add(it.dependencyProject)
                        } else if (it instanceof DefaultExternalModuleDependency)
                            projectsExclude.add("$it.group $it.name $it.version")
                    }
                    configurations.each { String config ->
                        try {
                            if (pjt.plugins.hasPlugin(LibraryPlugin)) {
                                pjt.configurations.getByName(config).dependencies.findAll {
                                    if (it instanceof DefaultProjectDependency) {
                                        !projectsExclude.contains(it.dependencyProject)
                                    } else if (it instanceof DefaultExternalModuleDependency)
                                        !projectsExclude.contains("$it.group $it.name $it.version")
                                    else
                                        false
                                }.each {
                                    mProject.configurations.getByName(config).dependencies.add(it)
                                }
                            }
                        } catch (Exception e) {
                            e.printStackTrace()
                        }
                    }
                }
            } else {
                // The purpose is to support the code hints
                mProject.dependencies.add(compileOnlyConfigName, dependency)
            }
        }
        mProject.gradle.removeListener(this)
    }

    @Override
    void afterResolve(ResolvableDependencies resolvableDependencies) {
    }
}