package com.cv.media.lib.geoip.manager;

import android.os.Handler;
import android.os.Message;
import android.util.Log;

import androidx.annotation.NonNull;

import com.cv.media.lib.common_utils.async.ThreadsBox;
import com.cv.media.lib.geoip.freegeoip.FreeGeoIPProvider;
import com.cv.media.lib.geoip.ipapi.IPApiGeoIPProvider;
import com.cv.media.lib.geoip.ipinfo.InfoGeoIPProvider;
import com.cv.media.lib.geoip.model.GeoIP;
import com.cv.media.lib.geoip.nekudo.NekudoGeoIPProvider;
import com.cv.media.lib.geoip.provider.GeoIPProvider;
import com.cv.media.lib.common_utils.provider.ContextProvider;
import com.cv.media.lib.common_utils.utils.Singleton;
import com.cv.media.lib.common_utils.utils.StringUtils;
import com.cv.media.lib.common_utils.utils.TimeZoneUtils;

/**
 * Location GeoIP Manager
 */
public class GeoIPManager {
    private static Singleton<GeoIPManager> singleton = new Singleton<GeoIPManager>() {
        @Override
        protected GeoIPManager create() {
            return new GeoIPManager();
        }
    };

    private Handler mHandler;
    private boolean sleepOnce = false;

    private GeoIPProvider mainProvider = null;
    //private GeoIPProvider freeGeoIPProvider = null;
    private GeoIPProvider ipapiGeoIPProvider = null;
    private GeoIPProvider infoGeoIPProvider = null;
    //private GeoIPProvider nekudoGeoIPProvider = null;
    private GeoIP geoIP;
    private volatile String countryCode;

    private GeoIPManager() {
        //this.nekudoGeoIPProvider = new NekudoGeoIPProvider(ContextProvider.getContext());
        //this.mainProvider = this.nekudoGeoIPProvider;
        //this.freeGeoIPProvider = new FreeGeoIPProvider(ContextProvider.getContext());
        //this.mainProvider = this.freeGeoIPProvider;
        this.ipapiGeoIPProvider = new IPApiGeoIPProvider(ContextProvider.getContext());
        this.mainProvider = this.ipapiGeoIPProvider;
        mHandler = new Handler(ThreadsBox.getNewHandlerThread(GeoIPManager.class.getSimpleName()).getLooper(), new Handler.Callback() {
            @Override
            public boolean handleMessage(@NonNull Message msg) {
                try {
                    saveGeoInfo(mainProvider.getGeoByCurIP().blockingLast());
                    if (StringUtils.isEmpty(getCountryCode())) {
                        throw new Exception();
                    }
                    mHandler.getLooper().quitSafely();
                } catch (Exception e) {
                    switchProvider();
                    if (sleepOnce) {
                        mHandler.postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                Log.d("GeoIP", "------>postDelayed.sendToTarget()");
                                sleepOnce = false;
                                mHandler.obtainMessage().sendToTarget();
                            }
                        }, 60000);
                    } else {
                        Log.d("GeoIP", "------>sendToTarget()");
                        mHandler.obtainMessage().sendToTarget();
                    }
                }
                return true;
            }
        });

        mHandler.obtainMessage().sendToTarget();
    }

    public static GeoIPManager getInstance() {
        return singleton.get();
    }

    public void switchProvider() {
        //NekudoGeoIPProvider已废弃
        //默认使用NekudoGeoIPProvider，如果当前不是NekudoGeoIPProvider，则需要转换为FreeGeoIPProvider
        //循环转换provider
//        if (mainProvider == nekudoGeoIPProvider) {
//            if (freeGeoIPProvider == null) {
//                freeGeoIPProvider = new FreeGeoIPProvider(ContextProvider.getContext());
//            }
//            mainProvider = freeGeoIPProvider;
//        } else
//        if (mainProvider == freeGeoIPProvider) {
//            if (ipapiGeoIPProvider == null) {
//                ipapiGeoIPProvider = new IPApiGeoIPProvider(ContextProvider.getContext());
//            }
//            mainProvider = ipapiGeoIPProvider;
//        } else
        if (mainProvider == ipapiGeoIPProvider) {
            if (infoGeoIPProvider == null) {
                infoGeoIPProvider = new InfoGeoIPProvider(ContextProvider.getContext());
            }
            mainProvider = infoGeoIPProvider;
        } else {
            mainProvider = ipapiGeoIPProvider;
            sleepOnce = true;
        }
    }

    private void saveGeoInfo(GeoIP geoIP) {
        if (!StringUtils.isEmpty(geoIP.getCountryCode())) {
            //todo 最后与GeoIP功能整合，而不是外面传入
            countryCode = geoIP.getCountryCode();
            this.geoIP = geoIP;
            Log.d("GeoIP", "------>" + countryCode);
            if (geoIP.getTimeZone() != null) {
                String curTimeZone = TimeZoneUtils.getTimeZone();
                if (geoIP.getTimeZone().equals(curTimeZone)) {
                    // Timber.i("Geo TimeZone : System time zone[%s] is same as detected. Don't need to modify.", curTimeZone);
                } else {
                    try {
                        TimeZoneUtils.setTimeZone(ContextProvider.getContext(), geoIP.getTimeZone());
                        // Timber.i("Geo TimeZone : Modified system time zone[%s] to detected time zone[%s]", curTimeZone, geoIP.getTimeZone());
                    } catch (Exception e) {
                        // Timber.e(e, "Error in modifying system time zone");
                    }
                }
            }
        }
    }

    public String getCountryCode() {
        return countryCode;
    }

    public GeoIP getGeoIP() {
        return geoIP;
    }

}
