package com.cv.media.lib.geoip.freegeoip;

import android.content.Context;

import io.reactivex.Observable;
import io.reactivex.functions.Function;

import com.cv.media.lib.geoip.provider.GeoIPProvider;
import com.cv.media.lib.geoip.factory.LenientGsonConverterFactory;
import com.cv.media.lib.geoip.model.GeoIP;
import com.cv.media.lib.common_utils.utils.StringUtils;

import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

/**
 * Created by Larry on 2016/6/14.
 */
public class FreeGeoIPProvider implements GeoIPProvider {
    private final static String HOST = "https://freegeoip.net";
    private Context mContext;

    private OkHttpClient.Builder mBuilder;
    private Retrofit.Builder mRetrofitBuilder;

    public FreeGeoIPProvider(Context context) {
        this.mContext = context;
    }

    private FreeGeoIPWebApi getApi() {
        if (null == mBuilder) {
            mBuilder = new OkHttpClient.Builder();
            mBuilder.followRedirects(true);
            mBuilder.followSslRedirects(true);
        }
        if (null == mRetrofitBuilder) {
            mRetrofitBuilder = new Retrofit.Builder();
            mRetrofitBuilder.addConverterFactory(LenientGsonConverterFactory.create());
            mRetrofitBuilder.addCallAdapterFactory(RxJava2CallAdapterFactory.create());
        }
        return mRetrofitBuilder.baseUrl(HOST).client(mBuilder.build()).build().create(FreeGeoIPWebApi.class);
    }

    public Observable<GeoIP> getGeoByIP(String ipAddress) {
        if (StringUtils.isEmpty(ipAddress)) {
            return convertResult(getApi().getGeoIP(""));
        } else {
            String[] dotNumbers = ipAddress.split(".");
            if (dotNumbers.length != 4) {
                return Observable.error(new RuntimeException("Invalid ip address format:" + ipAddress));
            }
            String formatted = String.format("%s-%s-%s-%s", dotNumbers[0], dotNumbers[1], dotNumbers[2], dotNumbers[3]);
            return convertResult(getApi().getGeoIP(formatted));
        }

    }

    private Observable<GeoIP> convertResult(Observable<GeoIPResult> observable) {
        return observable.map(new Function<GeoIPResult, GeoIP>() {
            @Override
            public GeoIP apply(GeoIPResult geoIPResult) {
                GeoIP geoIP = new GeoIP();
                geoIP.setCountryCode(geoIPResult.country_code);
                geoIP.setCountryName("");
                geoIP.setCity(geoIPResult.city);
                geoIP.setRegionCode(geoIPResult.region_code);
                geoIP.setRegionName(geoIPResult.region_name);
                geoIP.setTimeZone(geoIPResult.time_zone);
                geoIP.setLatitude(geoIPResult.latitude);
                geoIP.setLongitude(geoIPResult.longitude);
                return geoIP;
            }
        });
    }

    public Observable<GeoIP> getGeoByCurIP() {
        return getGeoByIP("");
    }
}
