package com.cv.media.lib.plugin

import org.gradle.api.GradleException

class PluginForEasyConfig {
    List<String> extraFlavorProjects
    List<String> moduleOnlyDependProjects
    List<String> platforms
    List<String> env
    public Closure platformConfiguration
    public Closure envConfiguration
    public Closure appModuleConfiguration

    List<String> getEnv() {
        env == null ? [] : env
    }

    List<String> getPlatforms() {
        platforms == null ? [] : platforms
    }

    List<String> getExtraFlavorProjects() {
        extraFlavorProjects == null ? [] : extraFlavorProjects
    }

    List<String> getModuleOnlyDependProjects() {
        moduleOnlyDependProjects == null ? [] : moduleOnlyDependProjects
    }

    void check() {
        if (platforms == null || platforms.isEmpty()) throw new GradleException(
                "\n*******请参考以下样式在根工程build.gradle下 配置App业务平台 ******* " + "\nPluginForEasy {\n" + "\tplatforms = [平台1, 平台2...]\n" +
                        "}\n" + "**************************************************************")
        else if (!platforms.findAll() { it == null || it.isEmpty() }.isEmpty()) throw new GradleException("业务平台名称不准配置空")

        if(env == null || env.isEmpty()) throw new GradleException(
                "\n*******请参考以下样式在根工程build.gradle下 配置App数据环境 ******* " + "\nPluginForEasy {\n" +"\tenv = [环境1, 环境2...]\n" +
                        "}\n" + "**************************************************************")
        else if (!env.findAll() { it == null || it.isEmpty() }.isEmpty()) throw new GradleException("数据环境名称不准配置空")
    }
}