package com.cv.media.lib.plugin.module

import org.gradle.api.DefaultTask
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.OutputDirectory
import org.gradle.api.tasks.TaskAction

class GenerateOriginModuleInfo extends DefaultTask {
    @Input
    List<String> moduleNames

    @Input
    String className

    @Input
    String pkgName

    @OutputDirectory
    File outputDir

    @TaskAction
    void generate() {
        ConfigClassGenerator configClassGenerator = new ConfigClassGenerator(pkgName, className, outputDir)

        List<String> modulesNameJoinList = new ArrayList<>()
        for (String name : moduleNames) {
            modulesNameJoinList.add("\"" + name + "\"")
        }
        configClassGenerator.addField("String[]", "MODULES", "{" + modulesNameJoinList.join(",") + "}")
        configClassGenerator.generate()
    }

}