package com.cv.media.lib.plugin.config

import com.android.build.gradle.api.BaseVariant
import com.cv.media.lib.plugin.Logger
import org.gradle.api.Project

class Environment {
    Project project;
    File fileEnv;
    File fileAll;
    BaseVariant variant;

    Environment(Project project, File fileEnv, File fileAll, BaseVariant variant) {
        this.project = project
        this.fileEnv = fileEnv
        this.fileAll = fileAll
        this.variant = variant
    }

    final void config() {
        Logger.startCount()
        Properties props = new Properties()
        props.load(new FileInputStream(fileAll))
        props.load(new FileInputStream(fileEnv))
        props.each { Map.Entry<String, String> entry ->
            if (entry.value.toLowerCase() == "true" || entry.value.toLowerCase() == "false") {
                variant.buildConfigField("boolean", entry.getKey(), entry.getValue())
            } else
                variant.buildConfigField("String", entry.getKey(), "\"${entry.getValue()}\"")
        }
        Logger.endCount("添加配置${variant.flavorName} 的环境变量 工程: " + project.name)
    }

    @Override
    String toString() {
        return getClass().getSimpleName()
    }
}