package com.cv.media.lib.plugin.config

import com.android.build.gradle.api.BaseVariant
import com.cv.media.lib.plugin.FileUtils
import org.gradle.api.Project

class VariantBuildConfiguration {
    static List<File> variants
    static void init(Project project) {
        variants = project.rootProject.file("./").listFiles().findAll {File file->
            return file.name.endsWith(".properties")
        }
    }

    private static List<File> getVariants() {
        return variants
    }

    static void config(Project project, BaseVariant variant) {
        new Environment(project,
                FileUtils.createPropertiesFileIfNeed(project.getRootProject().file("${variant.flavorName}.properties"), "此文件 配置 数据环境配置项"),
                FileUtils.createPropertiesFileIfNeed(project.getRootProject().file("${variant.productFlavors[0].name}All.properties"), "此文件 配置 数据环境通用配置项"),
                variant).config()
    }
}