package com.cv.media.lib.plugin.packing

import com.cv.media.lib.plugin.Logger
import org.gradle.api.GradleException

import java.util.zip.ZipEntry
import java.util.zip.ZipFile;

/**
 * 私有加固打包任务
 * 职责:
 * @author Damon
 */
class PrivateServiceApkPackingTask extends PublicServiceApkPackingTask{
    PrivateServiceApkPackingTask() {
        group "私有服务加固打包"
    }

    @Override
    File makeProtectedApk(File apkOriginFile) {
        def args = [
                "http://34.237.162.164:9999/api",   //encserviceurl
                "admin",                                   //username
                "${apkOriginFile.path}",                //filepath
                "${mOutputDir.path}",                  //encfilepath
                "",                                           //加固后apk本地名称(例如：abcd.apk 说明：只对普通加固有效，多渠道加固是无效的)
                "",                                           //so文件全路径例如：lib/a/b.so;lib/b/a.so多个so文件之间用;号隔开英文“;”最后一个后面不要带英文分号;
                "",                                           //签名别名标识
                1,                                           //是否API调用（1是，0否)
                "",                                           //方案id
                "start_zy.sh",                             //固定脚本名称
                "3"                                          //签名方式（默认使用Java签名方式）： 0:Java 3:Android V1 + Android V2;
        ]
        logs("加固 开始...")
        Logger.startCount()
        execute("java -jar ${toolsDir.path}${File.separator}encryptiontool-2.1.0.jar ${args.join(" ")}", "爱加密")
        Logger.endCount("加固任务")
        logs("加固 结束...")

        List<File> apks = mOutputDir.listFiles().findAll {
            it.name.contains("enc_unsigned.apk")
        }


        if (apks.size() != 1) {
            throw new GradleException("Apk加固异常: 找到${apks.size()}个匹配apk")
        }
        File protectApkFile = new File(mOutputDir, "${apkOriginFile.name.replace(".apk", "_protected.apk")}")
        logs("更改加固后apk:${apks[0].name}为: $protectApkFile.name")
        apks[0].renameTo(protectApkFile)
        if (!protectApkFile.exists()) throw new GradleException("Apk加固失败: 加固包不存在")

        logs("开始检查加固后apk: $protectApkFile.name")
        ZipFile zipFileOfPAF = new ZipFile(protectApkFile)
        Enumeration<?> entries = zipFileOfPAF.entries()
        boolean onlyOneDex = true
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry) entries.nextElement()
            if (entry.name.startsWith("classes") && entry.name.endsWith(".dex") && entry.name != "classes.dex") {
                onlyOneDex = false
                break
            }
        }

        if (!onlyOneDex) {
            throw new GradleException("Apk加固异常: 不止一个.dex")
        }

        logs("加固成功: $protectApkFile.name")
        return protectApkFile
    }
}
