package com.cv.media.lib.plugin.mvp

import com.android.build.gradle.*
import com.cv.media.lib.plugin.Logger
import org.gradle.api.Plugin
import org.gradle.api.Project

/**
* MVP架构辅助插件
* 职责:
* @author Damon
*/
class PluginForMVP implements Plugin<Project> {
    @Override
    void apply(Project project) {
        //为Project开启注解处理器
        project.dependencies {
            annotationProcessor project.lib_processor
        }
        config_processorInfo(project)
        try {
            def android
            if (project.plugins.hasPlugin(AppPlugin) || project.plugins.hasPlugin(DynamicFeaturePlugin)) {
                 android = project.extensions.getByType(AppExtension)
            }else if(project.plugins.hasPlugin(LibraryPlugin)){
                android = project.extensions.getByType(LibraryExtension)
            }
            def transformImpl = new MVPInitTransform(project)
            android.registerTransform(transformImpl)
            Logger.log("${project} MVP插件化处理")
        } catch (Exception e) {
            Logger.log("${project} MVP插件化处理 失败")
            Logger.e(e.toString())
        }
    }

    //配置 信息
    void config_processorInfo(Project project) {
        Logger.log("配置MVP注册:  ${project.name}")
        project.android.defaultConfig {
            javaCompileOptions {
                annotationProcessorOptions {
                    arguments MVP_MODULE_NAME: project.getName()
                }
            }
        }
    }
}
