package com.cv.media.lib.plugin

import com.android.utils.SparseArray
import com.google.common.collect.Maps

class Logger {
    final static boolean Debuggable = true
    final static String TAG = "MyPlugin:: >>>>> "

    static void i(String info) {
        log(info)
    }

    static void e(String info) {
        log(info)
    }

    static void w(String info) {
        log(info)
    }

    static void log(String info) {
        if (Debuggable) {
            println(TAG + info)
        }
    }

    static Map<String, Long> times = Maps.newTreeMap()

    static void startCount() {
        String key = getKey()
        if (key != null) {
            times.put(key, System.currentTimeMillis())
        }

    }

    static void endCount(String content) {
        String key = getKey()
        Long start = -1L
        if (key != null) {
            start = times.get(key, -1L)
        }
        if (start < 0) {
            log(content + " 花费时间: 时间出错")
            return
        }
        log(content + " 花费时间: ${(System.currentTimeMillis() - start)} 毫秒")
        times.remove(key)
    }

    static String getKey() {
        StackTraceElement[] elements = Thread.currentThread().stackTrace
        StackTraceElement keyE
        for (StackTraceElement element : elements) {
            if (!element.className.startsWith(Logger.name) && element.className.startsWith('com.cv.media.lib.plugin')) {
                keyE = element
                break
            }
        }
        if (keyE == null) return null
        return "${Thread.currentThread().hashCode()}_${keyE.className}_${keyE.methodName}"
    }


}
