package com.cv.media.lib.plugin.arouter

import org.objectweb.asm.*
/**
插入注册方法
@Author Damon
*/
class ByteCodeGenerator {
    static final String GENERATE_TO_METHOD_NAME = 'registerARouterComponent'
    static final String GENERATE_TO_METHOD_DESC = '()V'
    static final String INVOKEPOINT_METHOD_NAME = 'onCreate'
    static final String INVOKEPOINT_METHOD_DESC = '()V'

    List<ScanSetting> arouterClassesInfo
    File injectClassFile

    ByteCodeGenerator(List<ScanSetting> arouterClassesInfo, File injectClassFile) {
        this.arouterClassesInfo = arouterClassesInfo
        this.injectClassFile = injectClassFile
    }

    void start() {
        def optClassFile = new File(injectClassFile.getParent(), injectClassFile.name + ".opt")
        if (optClassFile.exists()) {
            optClassFile.delete()
        }
        FileOutputStream outputStream = new FileOutputStream(optClassFile)
        InputStream inputStream = new FileInputStream(injectClassFile)
        outputStream.write(inject(inputStream))
        outputStream.close()
        inputStream.close()
        injectClassFile.delete()
        optClassFile.renameTo(injectClassFile)
    }

    private byte[] inject(InputStream inputStream) {
        ClassReader cr = new ClassReader(inputStream)
        ClassWriter cw = new ClassWriter(ClassWriter.COMPUTE_MAXS)
        ClassVisitor cv = new MyClassVisitor(Opcodes.ASM5, cw)
        cr.accept(cv, ClassReader.EXPAND_FRAMES)
        return cw.toByteArray()
    }

    static void injectCode(File classFile, List<ScanSetting> info) {
        List<ScanSetting> arr = []
        if (classFile != null && classFile.exists() && classFile.isFile() && info != null && info.size() > 0) {
            info.each { ScanSetting item ->
                if (item.classList != null && item.classList.size() > 0) {
                    arr.add(item)
                }
            }
            new ByteCodeGenerator(arr, classFile).start()
        }
    }

    class MyClassVisitor extends ClassVisitor {
        boolean needInsertInvokePoint = true
        private String superName
        private String className
        MyClassVisitor(int api, ClassVisitor cv) {
            super(api, cv)
        }

        @Override
        void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces)
            this.superName = superName
            this.className = name
        }

        @Override
        MethodVisitor visitMethod(int access, String name, String desc,
                                  String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions)
            if (name == GENERATE_TO_METHOD_NAME) {
                mv = new RegMethodVisitor(Opcodes.ASM5, mv)
            }else if(name == INVOKEPOINT_METHOD_NAME) {
                needInsertInvokePoint = false
                mv = new InvokeRegMethodVisitor(Opcodes.ASM5, mv, MyClassVisitor.this.superName, MyClassVisitor.this.className)
            }
            return mv
        }

        @Override
        void visitEnd() {
            if (needInsertInvokePoint) {
                insertInvokePointMethod()
            }
            super.visitEnd()
        }

        void insertInvokePointMethod() {
            MethodVisitor mv = cv.visitMethod(Opcodes.ACC_PROTECTED, INVOKEPOINT_METHOD_NAME, INVOKEPOINT_METHOD_DESC, null, null)
            mv.visitVarInsn(Opcodes.ALOAD, 0)
            mv.visitMethodInsn(Opcodes.INVOKEVIRTUAL, MyClassVisitor.this.className, GENERATE_TO_METHOD_NAME, GENERATE_TO_METHOD_DESC, false)
            mv.visitVarInsn(Opcodes.ALOAD, 0)
            mv.visitVarInsn(Opcodes.ALOAD, 1)
            mv.visitMethodInsn(Opcodes.INVOKESPECIAL, MyClassVisitor.this.superName, INVOKEPOINT_METHOD_NAME, INVOKEPOINT_METHOD_DESC, false)
            mv.visitInsn(Opcodes.RETURN)
        }
    }

    class InvokeRegMethodVisitor extends MethodVisitor {
        private String superName
        private String className

        InvokeRegMethodVisitor(int api, MethodVisitor mv, String superName, String className) {
            super(api, mv)
            this.superName = superName
            this.className = className
        }

        @Override
        void visitCode() {
            super.visitCode()
            mv.visitVarInsn(Opcodes.ALOAD, 0)
            mv.visitMethodInsn(Opcodes.INVOKEVIRTUAL, InvokeRegMethodVisitor.this.className, GENERATE_TO_METHOD_NAME, "()V", false)
        }

//        @Override
//        void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
//            super.visitMethodInsn(opcode, owner, name, desc, itf)
////            if (superName == owner && name == INVOKEPOINT_METHOD_NAME) {
////
////            }
//        }
    }

    class RegMethodVisitor extends MethodVisitor {
        RegMethodVisitor(int api, MethodVisitor mv) {
            super(api, mv)
        }

        @Override
        void visitCode() {
            arouterClassesInfo.each { ScanSetting item ->
                if (item.interfaceName.endsWith('IRouteRoot')) {
                    item.classList.each { String rootImplName ->
                        mv.visitTypeInsn(Opcodes.NEW, rootImplName)
                        mv.visitInsn(Opcodes.DUP)
                        mv.visitMethodInsn(Opcodes.INVOKESPECIAL, rootImplName, "<init>", "()V", false)
                        mv.visitMethodInsn(Opcodes.INVOKESTATIC, ScanSetting.REGISTER_CLASS_FULL, ScanSetting.REGISTER_IROUTEROOT_METHOD_NAME, "(L${item.interfaceName};)V", false)
                    }
                } else if (item.interfaceName.endsWith('IProviderGroup')) {
                    item.classList.each { String providerImplName ->
                        mv.visitTypeInsn(Opcodes.NEW, providerImplName)
                        mv.visitInsn(Opcodes.DUP)
                        mv.visitMethodInsn(Opcodes.INVOKESPECIAL, providerImplName, "<init>", "()V", false)
                        mv.visitMethodInsn(Opcodes.INVOKESTATIC, ScanSetting.REGISTER_CLASS_FULL, ScanSetting.REGISTER_IPROVIDER_METHOD_NAME, "(L${item.interfaceName};)V", false)
                    }
                } else if (item.interfaceName.endsWith('IInterceptorGroup')) {
                    item.classList.each { String interceptorImplName ->
                        mv.visitTypeInsn(Opcodes.NEW, interceptorImplName)
                        mv.visitInsn(Opcodes.DUP)
                        mv.visitMethodInsn(Opcodes.INVOKESPECIAL, interceptorImplName, "<init>", "()V", false)
                        mv.visitMethodInsn(Opcodes.INVOKESTATIC, ScanSetting.REGISTER_CLASS_FULL, ScanSetting.REGISTER_IINTERCEPTOR_METHOD_NAME, "(L${item.interfaceName};)V", false)
                    }
                }
            }
            super.visitCode()
        }
    }
}
