package com.cv.media.lib.plugin

import org.gradle.api.GradleException
import org.gradle.api.Project
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationContainer
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependency
import org.gradle.api.internal.artifacts.dsl.dependencies.DefaultDependencyHandler

class DependencyCheck{
    static void checkDependency(Project pjt, List<String> moduleOverLap) {
        //服务层 工程
        if(pjt.name.startsWith(Constants.projectNamePrefix_Component)) {
            DefaultConfigurationContainer configurationContainer = ((DefaultDependencyHandler)( ((Project)pjt).getDependencies())).getAdditionalMethods().configurationContainer
            List dependencies = []
            dependencies.addAll(configurationContainer.findByName("implementation").dependencies.toList())
            dependencies.addAll(configurationContainer.findByName("api").dependencies.toList())
            dependencies.addAll(configurationContainer.findByName("compile").dependencies.toList())
            dependencies.each { def dependency ->
                if(dependency instanceof DefaultProjectDependency && dependency.group.contains(pjt.rootProject.name) && moduleOverLap.contains(dependency.name)) {
                    throw new GradleException("服务层${pjt.name} 错误依赖 ${dependency.name}(c层禁止依赖项)");
                }
            }
        }
    }
}