package com.cv.media.lib.plugin.dependencies

import com.cv.media.lib.plugin.Constants
import com.cv.media.lib.plugin.FileUtils
import org.codehaus.groovy.runtime.StringGroovyMethods
import org.gradle.api.GradleException
import org.gradle.api.Project
import org.gradle.internal.extensibility.DefaultExtraPropertiesExtension

import java.lang.reflect.Field
import java.util.Map.Entry

class DependenciesInjector {
    Properties props = new Properties()
    Map<String, Object> dependencies = new HashMap<>()
    Project rootProject
    Field extMapField = DefaultExtraPropertiesExtension.class.declaredFields[0]


    void init(Project project) {
        if (project.rootProject == project) {
            rootProject = project
        } else
            throw new GradleException("DependenciesInjector初始化依赖根工程")
        extMapField.setAccessible(true)
        loadDependencies()
    }

    void inject(Project project) {
        HashMap map = extMapField.get(project.ext)
        map.putAll(dependencies)
    }

    void loadDependencies() {
        props.load(new FileInputStream(FileUtils.createPropertiesFileIfNeed(rootProject.file(Constants.dependenciesFileName), "此文件配置依赖项别名")))
        props.entrySet().sort { Entry<Object, Object> a, Entry<Object, Object> b ->
            String aV = a.value
            String bV = b.value
            int aWeight = (isProjectDependPattern(aV) ? 0 : 1) + (isRepoDependPattern(aV) ? 0 : 1) + (isArrayDependPattern(aV) ? -1 : 1)
            int bWeight = (isProjectDependPattern(bV) ? 0 : 1) + (isRepoDependPattern(bV) ? 0 : 1) + (isArrayDependPattern(bV) ? -1 : 1)
            aWeight == bWeight ? 0 : (aWeight > bWeight ? -1:1)
        }.each {
            def obj = transform(it)
            if (obj == null) throw new GradleException("${Constants.dependenciesFileName} ${it.key} ${it.value} 配置有问题")
            dependencies[it.key] = obj
        }
    }

    boolean isProjectDependPattern(String value) {
        (value =~ '^:.*\$').size() > 0
    }

    boolean isRepoDependPattern(String value) {
        (value =~ '^[a-z][^:]*:[^:]*:[^:]*\$').size() > 0
    }

    boolean isArrayDependPattern(String value) {
        (value =~ '^\\[[^\\]\\[]*]\$').size() > 0
    }

    Object transform(Entry<String, String> entry) {
        def value = entry.value
        if (isProjectDependPattern(value)) {
            //project依赖
            return rootProject.findProject(value)
        } else if (isRepoDependPattern(value)) {
            //仓库依赖
            def matcher = value =~ '\\\$\\{[^${}]*}'
            if (matcher.size() > 0) {
                def end = matcher.size() - 1
                for (int index in 0..end) {
                    String match = StringGroovyMethods.getAt(matcher, index)
                    String param = match.substring(2, match.length() - 1)
                    String paramReflection = dependencies[param]
                    if (paramReflection == null) throw new GradleException("${Constants.dependenciesFileName} ${entry.key} ${entry.value} ${param} 参数找不到对应值")
                    value = value.replace(match, paramReflection)
                }
            }
            return value
            //仓库依赖
        } else if (isArrayDependPattern(value)) {
            //依赖数组
            value = value.substring(1, value.length() - 1)
            List arr = []
            value.split(",").each {
                arr.add(dependencies[it])
            }
            return arr
        } else {
            //定义了别的东西
            return entry.value
            //throw new GradleException("${Constants.dependenciesFileName} ${entry.key} ${entry.value} 值非法, 只允许定义[1. 工程依赖 2. 仓库依赖 ]")
        }
    }
}