package com.cv.media.lib.plugin.packing

import com.cv.media.lib.plugin.Logger
import org.gradle.api.GradleException

import java.util.zip.ZipEntry
import java.util.zip.ZipFile

/**
 * 私有加固打包任务
 * 职责:
 * @author Damon
 */
class PrivateServiceApkPackingTask extends PublicServiceApkPackingTask {

    PrivateServiceApkPackingTask() {
        setGroup("私有服务加固打包");
    }

    @Override
    File makeProtectedApk(File apkOriginFile) {
        logs("加固 开始...")
        Logger.startCount()
        String[] argArr = new String[11 + 3]
        argArr[0] = "java"
        argArr[1] = "-jar"
        argArr[2] = "${toolsDir.path}${File.separator}encryptiontool-2.1.0.jar".toString()
        argArr[3 + 0] = "http://34.237.162.164:9999/api"
        argArr[3 + 1] = "admin"
        argArr[3 + 2] = "${apkOriginFile.path}"
        argArr[3 + 3] = "${mOutputDir.path}"
        argArr[3 + 4] = "enc_unsigned.apk"
        argArr[3 + 5] = ""
        argArr[3 + 6] = ""
        argArr[3 + 7] = "1"
        argArr[3 + 8] = ""
        argArr[3 + 9] = "start_zy.sh"
        argArr[3 + 10] = "3"

        String[] javaVersion = new String[2]
        javaVersion[0] = "java"
        javaVersion[1] = "-version"
        execute(javaVersion, "Goose私有爱加密服务")
        Logger.startCount()
        execute(argArr, "Goose私有爱加密服务")
        Logger.endCount("加固任务")
        logs("加固 结束...")

        List<File> apks = mOutputDir.listFiles().findAll {
            it.name.contains("enc_unsigned.apk")
        }

        if (apks.size() != 1) {
            throw new GradleException("Apk加固异常: 找到${apks.size()}个匹配apk")
        }
        File protectApkFile = new File(mOutputDir, "${apkOriginFile.name.replace(".apk", "_protected.apk")}")
        logs("更改加固后apk:${apks[0].name}为: $protectApkFile.name")
        apks[0].renameTo(protectApkFile)
        if (!protectApkFile.exists()) throw new GradleException("Apk加固失败: 加固包不存在")

        logs("开始检查加固后apk: $protectApkFile.name")
        ZipFile zipFileOfPAF = new ZipFile(protectApkFile)
        Enumeration<?> entries = zipFileOfPAF.entries()
        boolean onlyOneDex = true
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry) entries.nextElement()
            if (entry.name.startsWith("classes") && entry.name.endsWith(".dex") && entry.name != "classes.dex") {
                onlyOneDex = false
                break
            }
        }

        if (!onlyOneDex) {
            throw new GradleException("Apk加固异常: 不止一个.dex")
        }

        logs("加固成功: $protectApkFile.name")
        return protectApkFile
    }

    @Override
    void logs(String content) {
        println("${PrivateServiceApkPackingTask.simpleName}--> ${content}");
    }

    void execute(String[] commands, String tag) {
        Process process = Runtime.getRuntime().exec(commands)
        logs("tag:${tag} 执行命令: ${commands.join(" ")}")
        BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(process.getInputStream()))
        BufferedReader stderrReader = new BufferedReader(new InputStreamReader(process.getErrorStream()))
        String line
        while ((line = stdoutReader.readLine()) != null || (line = stderrReader.readLine()) != null) {
            logs("${tag}:: " + line)
        }
        stdoutReader.close();
        stderrReader.close();
    }
}
