package com.cv.media.lib.plugin.arouter


import com.android.build.gradle.AppPlugin
import com.android.build.gradle.DynamicFeaturePlugin
import com.cv.media.lib.plugin.Logger
import com.cv.media.lib.plugin.MainLibraryPlugin
import org.gradle.api.Plugin
import org.gradle.api.Project

class PluginForArouter implements Plugin<Project> {
    @Override
    void apply(Project project) {
        config_Arouter(project)
        try {
            if (project.plugins.hasPlugin(AppPlugin) || project.plugins.hasPlugin(DynamicFeaturePlugin) || project.plugins.hasPlugin(MainLibraryPlugin)) {
                Logger.log("${project} Arouter插件化处理")
                def transformImpl = new ArouterInitTransform(project)
                project.extensions.android.registerTransform(transformImpl)
            }
        } catch (Exception e) {
            Logger.log("${project} Arouter插件化处理 失败")
            Log.e(e.toString())
        }
    }

    //配置 Arouter信息
    void config_Arouter(Project project) {
        Logger.log("配置阿里路由:  ${project.name}")
        project.dependencies {
            def libVersion='2.1.0'
            implementation "com.cv.media.lib:lib_arouter_api:${libVersion}"
            annotationProcessor "com.cv.media.lib:lib_arouter_compiler:${libVersion}"
        }

        project.android.defaultConfig {
            javaCompileOptions {
                annotationProcessorOptions {
                    arguments AROUTER_MODULE_NAME: project.getName()
                    arguments AROUTER_GENERATE_DOC: "enable"
                }
            }
        }
    }
}
