package com.cv.media.lib.gradle.publish

/**
 * 仓库配置
 * 职责:
 * @author Damon
 */
class MavenConfig implements Cloneable {
    Boolean isSnapshot
    String groupId
    String artifactId
    String version
    String repoRelease
    String repoReleaseUser
    String repoReleasePsw
    String repoSnapshot
    String repoSnapshotUser
    String repoSnapshotPsw

    String getFullVersion() {
        version + (isSnapshot ? "-SNAPSHOT" : "")
    }

    String getRepo() {
        isSnapshot ? repoSnapshot : repoRelease
    }

    String getRepoUsrName() {
        isSnapshot ? repoSnapshotUser : repoReleaseUser
    }

    String getRepoPsw() {
        isSnapshot ? repoSnapshotPsw : repoReleasePsw
    }

    void mergeBase(MavenConfig base) {
        if (base != null) {
            if (isEmpty(groupId)) groupId = base.groupId
            if (isEmpty(version)) version = base.version
            if (isEmpty(repoRelease)) repoRelease = base.repoRelease
            if (isEmpty(repoReleaseUser)) repoReleaseUser = base.repoReleaseUser
            if (isEmpty(repoReleasePsw)) repoReleasePsw = base.repoReleasePsw
            if (isEmpty(repoSnapshot)) repoSnapshot = base.repoSnapshot
            if (isEmpty(repoSnapshotUser)) repoSnapshotUser = base.repoSnapshotUser
            if (isEmpty(repoSnapshotPsw)) repoSnapshotPsw = base.repoSnapshotPsw
            if (isEmpty(isSnapshot)) isSnapshot = base.isSnapshot
        }
    }

    private static boolean isEmpty(Object o) {
        if (o == null) return true
        if (o instanceof String && o.isEmpty()) return true
        return false
    }
}

