package com.lg.lib.gradle.sdk

import org.gradle.api.GradleException
import org.gradle.api.Plugin
import org.gradle.api.Project

class SdkAssistantPlugin implements Plugin<Project> {
    final String extensionName = "PluginForSdk"
    SdkRootConfig rootConfig
    @Override
    void apply(Project project) {
        if (target == target.getRootProject()) {
            target.extensions.create(extensionName, SdkRootConfig)
            target.afterEvaluate {
                rootConfig = target.extensions.getByType(MavenConfigRoot)

            }
        }
    }

    void checkConfig(SdkRootConfig config) {
        def errorInfo = ""
        config.properties.findAll {
            it.value == null && it.key != 'taskThatOwnsThisObject'
        }.each {
            errorInfo += "\n${extensionName}->${it.key} 没有配置"
        }
        if (!errorInfo.isEmpty()) throw new GradleException(errorInfo)
    }


    void displayInstructions() {
        println "**************************************************************"
        println "**************************************************************"
        println "******************$extensionName 配置说明******************"
        println "请在根工程 下build.gradle中配置: \n" +
                "$extensionName {\n" +
                "\tisSnapshot value(boolean 所有的子工程都会应用, 若要单独控制, 子工程覆写)\n" +
                "\tgroupId value(String 所有的子工程都会应用, 若要单独控制, 子工程覆写)\n" +
                "\tversion value(String 所有的子工程都会应用, 若要单独控制, 子工程覆写)\n" +
                "\trepoRelease value(String 所有的子工程都会应用, 若要单独控制, 子工程覆写)\n" +
                "\trepoReleaseUser value(String 所有的子工程都会应用, 若要单独控制, 子工程覆写)\n" +
                "\trepoReleasePsw value(String 所有的子工程都会应用, 若要单独控制, 子工程覆写)\n" +
                "\trepoSnapshot value(String 所有的子工程都会应用, 若要单独控制, 子工程覆写)\n" +
                "\trepoSnapshotUser value(String 所有的子工程都会应用, 若要单独控制, 子工程覆写)\n" +
                "\trepoSnapshotPsw value(String 所有的子工程都会应用, 若要单独控制, 子工程覆写)\n" +
                "}"
        println "子工程 请在子工程 下build.gradle同样配置 比如:"
        println "$extensionName { \n" +
                "\tartifactId value(String 默认为工程名)\n" +
                "\tversion newValue(String 如果有单独的版本控制, 就设置一个新的版本号)\n" +
                "}\n"
        println "**************************************************************"
        println "**************************************************************"
        println "**************************************************************"
    }
}