package com.cv.media.lib.imdb.zulu;

public enum PolicyType {
    ApkUpdateUrl,
    MetricsClickstreamPolicy,
    AmazonInsightPolicy,
    ComscorePolicy,
    TunePolicy,
    SsoTestGoodPolicy,
    SsoTestLinkedPolicy,
    FacebookAppId,
    ForesterPolicy,
    MobileDiagnostics,
    ZuluApiPolicy,
    AmazonAdAppKeyPolicy;

    protected SignatureEncoding finalSignatureEncoding;
    protected boolean hasId;
    protected boolean hasPolicy;
    protected boolean hasPolicyVersion;
    protected boolean hasSignature;
    protected KeyEncoding keyEncoding;
    protected CryptoAlgorithm keySpecAlgorithm;
    protected CryptoAlgorithm macAlgorithm;
    protected int policyLength;
    protected int signatureLength;
    protected int spreadingCode;

    static {
        ApkUpdateUrl.withVariableLengthSignature().withSpreadingCode(1717986918);
        MetricsClickstreamPolicy.withVariableLengthPolicy().withSignatureLength(88).withPolicyVersion().withSpreadingCode(1522817732).withKeySpecAlgorithm(CryptoAlgorithm.AES).withMacAlgorithm(CryptoAlgorithm.HMAC_SHA256).withKeyEncoding(KeyEncoding.BASE64);
        AmazonInsightPolicy.withPolicyLength(32).withSignatureLength(44).withSpreadingCode(404232216);
        ComscorePolicy.withVariableLengthPolicy().withSignatureLength(32).withSpreadingCode(858993459);
        TunePolicy.withPolicyLength(6).withSignatureLength(32).withSpreadingCode(858993459);
        SsoTestGoodPolicy.withVariableLengthPolicy().withVariableLengthSignature().withSpreadingCode(1515870810);
        SsoTestLinkedPolicy.withVariableLengthPolicy().withVariableLengthSignature().withSpreadingCode(1515870810);
        FacebookAppId.withSignatureLength(15).withSpreadingCode(1916170806);
        ForesterPolicy.withVariableLengthPolicy().withPolicyVersion().withSpreadingCode(1521113770);
        MobileDiagnostics.withVariableLengthPolicy().withVariableLengthSignature().withSpreadingCode(1014840445);
        ZuluApiPolicy.withVariableLengthPolicy().withVariableLengthSignature().withSpreadingCode(1685889765).withKeyAndMacAlgorithm(CryptoAlgorithm.HMAC_SHA256).withSignatureEncoding(SignatureEncoding.BASE64).withKeyEncoding(KeyEncoding.UTF8BYTES);
        AmazonAdAppKeyPolicy.withVariableLengthPolicy().withVariableLengthSignature().withSpreadingCode(976894522);
    }

    private PolicyType withId() {
        this.hasId = true;
        return this;
    }

    private PolicyType withKeyAndMacAlgorithm(CryptoAlgorithm cryptoAlgorithm) {
        this.keySpecAlgorithm = cryptoAlgorithm;
        this.macAlgorithm = cryptoAlgorithm;
        return this;
    }

    private PolicyType withKeyEncoding(KeyEncoding keyEncoding) {
        this.keyEncoding = keyEncoding;
        return this;
    }

    private PolicyType withKeySpecAlgorithm(CryptoAlgorithm cryptoAlgorithm) {
        this.keySpecAlgorithm = cryptoAlgorithm;
        return this;
    }

    private PolicyType withMacAlgorithm(CryptoAlgorithm cryptoAlgorithm) {
        this.macAlgorithm = cryptoAlgorithm;
        return this;
    }

    private PolicyType withPolicyLength(int i) {
        this.hasPolicy = true;
        this.policyLength = i;
        return this;
    }

    private PolicyType withPolicyVersion() {
        this.hasPolicyVersion = true;
        return this;
    }

    private PolicyType withSignatureEncoding(SignatureEncoding signatureEncoding) {
        this.finalSignatureEncoding = signatureEncoding;
        return this;
    }

    private PolicyType withSignatureLength(int i) {
        this.hasSignature = true;
        this.signatureLength = i;
        return this;
    }

    private PolicyType withSpreadingCode(int i) {
        this.spreadingCode = i;
        return this;
    }

    private PolicyType withVariableLengthPolicy() {
        this.hasPolicy = true;
        this.policyLength = 0;
        return this;
    }

    private PolicyType withVariableLengthSignature() {
        this.hasSignature = true;
        this.signatureLength = 0;
        return this;
    }

    public SignatureEncoding getFinalSignatureEncoding() {
        return this.finalSignatureEncoding;
    }

    public KeyEncoding getKeyEncoding() {
        return this.keyEncoding;
    }

    public CryptoAlgorithm getKeySpecAlgorithm() {
        return this.keySpecAlgorithm;
    }

    public CryptoAlgorithm getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public int getPolicyLength() {
        return this.policyLength;
    }

    public int getSignatureLength() {
        return this.signatureLength;
    }

    public int getSpreadingCode() {
        return this.spreadingCode;
    }

    public boolean hasId() {
        return this.hasId;
    }

    public boolean hasPolicy() {
        return this.hasPolicy;
    }

    public boolean hasPolicyVersion() {
        return this.hasPolicyVersion;
    }

    public boolean hasSignature() {
        return this.hasSignature;
    }

    public boolean isPolicyFixedLength() {
        return this.policyLength != 0;
    }

    public boolean isSignatureFixedLength() {
        return this.signatureLength != 0;
    }

    public enum SignatureEncoding {
        BASE64,
        HEX
    }

    public enum KeyEncoding {
        ASCII,
        BASE64,
        UTF8BYTES
    }

    public enum CryptoAlgorithm {
        AES,
        HMAC_SHA1,
        HMAC_SHA256,
        NONE
    }
}
