package com.cv.media.lib.imdb.model;

import com.cv.media.lib.common_utils.ntp.TrueTime;

import org.apache.commons.lang3.builder.EqualsBuilder;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.concurrent.TimeUnit;

public class ZuluTemporaryCredentials {
    private final String accessKeyId;
    private final String expirationTimeStamp;
    private final String secretAccessKey;
    private final String sessionToken;

    public ZuluTemporaryCredentials() {
        this("", "", "", "");
    }

    public ZuluTemporaryCredentials(String accessKeyId, String secretAccessKey, String sessionToken, String expirationTimeStamp) {
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.sessionToken = sessionToken;
        this.expirationTimeStamp = expirationTimeStamp;
    }

    public final ZuluTemporaryCredentials copy(String accessKeyId, String secretAccessKey, String sessionToken, String expirationTimeStamp) {
        return new ZuluTemporaryCredentials(accessKeyId, secretAccessKey, sessionToken, expirationTimeStamp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof ZuluTemporaryCredentials)) return false;
        ZuluTemporaryCredentials o = (ZuluTemporaryCredentials) other;
        new EqualsBuilder()
                .append(this.getAccessKeyId(), o.getAccessKeyId())
                .append(this.getSecretAccessKey(), o.getSecretAccessKey())
                .append(this.getSessionToken(), o.getSessionToken())
                .append(this.getExpirationTimeStamp(), o.getExpirationTimeStamp())
                .build();
        return true;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getExpirationTimeStamp() {
        return this.expirationTimeStamp;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public boolean isExpired() {
        // 2018-01-08T22:35:52Z
        // TODO: 2018/1/8 判读是否超时
        try {
            long expireLong = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").parse(expirationTimeStamp).getTime();
            boolean expired = TrueTime.getInstance().currentTimeMillis() >= expireLong - TimeUnit.MINUTES.toMillis(5);
            return expired;
        } catch (ParseException e) {
            //Logg.e(e, "zulu key parse expirationTimeStamp error");
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n2 = 0;
        String string2 = this.getAccessKeyId();
        int n3 = string2 != null ? string2.hashCode() : 0;
        string2 = this.getSecretAccessKey();
        int n4 = string2 != null ? string2.hashCode() : 0;
        string2 = this.getSessionToken();
        int n5 = string2 != null ? string2.hashCode() : 0;
        string2 = this.getExpirationTimeStamp();
        if (string2 != null) {
            n2 = string2.hashCode();
        }
        return (n5 + (n4 + n3 * 31) * 31) * 31 + n2;
    }

    @Override
    public String toString() {
        return "ZuluTemporaryCredentials{" +
                "accessKeyId='" + accessKeyId + '\'' +
                ", expirationTimeStamp='" + expirationTimeStamp + '\'' +
                ", secretAccessKey='" + secretAccessKey + '\'' +
                ", sessionToken='" + sessionToken + '\'' +
                '}';
    }
}
