package com.cv.media.lib.imdb;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.cv.media.lib.imdb.adapter.SearchNewDeserializer;
import com.cv.media.lib.imdb.model.GetTempCredentialsResponseOuter;
import com.cv.media.lib.imdb.model.SearchNewResult;
import com.cv.media.lib.imdb.model.SearchObject;
import com.cv.media.lib.imdb.model.ZuluTemporaryCredentials;
import com.cv.media.lib.imdb.zulu.ZuluKey;
import com.cv.media.lib.imdb.zulu.ZuluSigner;
import com.cv.media.lib.imdb.zulu.ZuluSigningInterceptor;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import io.reactivex.Observable;
import io.reactivex.functions.Function;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

public class ImdbSearchServer implements ZuluKey {
    private static ImdbSearchServer INSTANCE = new ImdbSearchServer();
    public final static String IMDB_TYPE_MOVIE = "movie";
    public final static String IMDB_TYPE_TVMOVIE = "tvMovie";
    public final static String IMDB_TYPE_SHORT = "short";
    public final static String IMDB_TYPE_FEATURE = "feature";
    public final static String IMDB_TYPE_DOCUMENTARY = "documentary";
    public final static String IMDB_TYPE_TVSHOW = "tvSeries";
    public final static String IMDB_TYPE_TV_SERIES = "tv_series";
    public final static String IMDB_TYPE_TVMINISHOW = "tvMiniSeries";
    public final static String IMDB_TYPE_CELEBRITY = "celebrity";

    public static ImdbSearchServer getInstance() {
        return INSTANCE;
    }

    private ImdbApi mSearchApi;
    private ImdbApi mZuluApi;
    private ZuluTemporaryCredentials latestKey;

    private OkHttpClient.Builder getOkHttpBuilder(){
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        SSLContext sslContext = getSslContext();
        if (sslContext != null) {
            // 设置忽略ssl证书
            builder.sslSocketFactory(sslContext.getSocketFactory(), xtm);
        }

        builder.hostnameVerifier((hostname, session) -> true);
        return builder;
    }

    public ImdbSearchServer() {
       xtm = new X509TrustManager() {
            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                //return null; okhttp 3.0
                return new X509Certificate[]{};
            }
        };

        OkHttpClient zuluHttpClient = getOkHttpBuilder()
                .addInterceptor(new ZuluSigningInterceptor(this, new ZuluSigner()))
                .build();

        Gson newSearchGson = new GsonBuilder().registerTypeAdapter(SearchObject.class, new SearchNewDeserializer()).create();
        Retrofit retrofit = new Retrofit.Builder()
                .client(zuluHttpClient)
                .baseUrl("https://api.imdbws.com")
                .addConverterFactory(GsonConverterFactory.create(newSearchGson))
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                .build();
        mSearchApi = retrofit.create(ImdbApi.class);

        OkHttpClient client = getOkHttpBuilder()
                .connectTimeout(15, TimeUnit.SECONDS)
                .readTimeout(15, TimeUnit.SECONDS)
                .addInterceptor(new Interceptor() {
                    @Override
                    public Response intercept(Chain chain) throws IOException {
                        Request request = chain.request().newBuilder()
                                .method("POST", RequestBody.create(MediaType.parse("application/json"), "{\"appKey\":\"a1bac899-b6a3-495d-a21d-97b979899ddd\"}"))
                                .build();
                        return chain.proceed(request);
                    }
                })
                .build();
        retrofit = new Retrofit.Builder()
                .client(client)
                .baseUrl("https://api.imdbws.com")
                .addConverterFactory(GsonConverterFactory.create())
                .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                .build();
        mZuluApi = retrofit.create(ImdbApi.class);
    }

    public Observable<ZuluTemporaryCredentials> getZuluKey() {
        if (null != latestKey && !latestKey.isExpired()) {
            return Observable.just(latestKey);
        } else {
            return mZuluApi.getCredentials()
                    .map(new Function<GetTempCredentialsResponseOuter, ZuluTemporaryCredentials>() {
                        @Override
                        public ZuluTemporaryCredentials apply(GetTempCredentialsResponseOuter getTempCredentialsResponseOuter) {
                            latestKey = getTempCredentialsResponseOuter.getResource();
                            return latestKey;
                        }
                    });
        }
    }

    public Observable<SearchNewResult> rxImdbNewSearch(final String query) {
        return getZuluKey()
                .flatMap(new Function<ZuluTemporaryCredentials, Observable<SearchNewResult>>() {
                    @Override
                    public Observable<SearchNewResult> apply(ZuluTemporaryCredentials zuluTemporaryCredentials) {
                        if (null != zuluTemporaryCredentials) {
                            return mSearchApi.search(query);
                        } else {
                            throw new RuntimeException("get zulu key failed");
                        }
                    }
                });
    }

    @Override
    public void renew() {
        /*try {
            OkHttpClient okHttpClient = new OkHttpClient.Builder().build();
            RequestBody requestBody = RequestBody.create(MediaType.parse("application/json"), "{\"appKey\":\"a1bac899-b6a3-495d-a21d-97b979899ddd\"}");
            Request request = new Request.Builder()
                    .url("https://api.imdbws.com/authentication/credentials/temporary/android0702")
                    .method("POST", requestBody)
                    .build();
            String credentials = okHttpClient.newCall(request).execute().body().string();
            Gson gson = new Gson();
            latestKey = gson.fromJson(credentials, GetTempCredentialsResponseOuter.class).getResource();
            UserPreferences.getInstance().put(PreferenceConstant.ZULU_KEY, gson.toJson(latestKey));
        } catch (IOException e) {
            TimberUtils.e(e, "imdb search: ZuluKey renew error");
        }*/
    }

    @Override
    public void clean() {
//        UserPreferences.getInstance().remove(PreferenceConstant.ZULU_KEY);
    }

    @Override
    public ZuluTemporaryCredentials getZuluCredentials(boolean forceRefresh) {
        return latestKey;
    }

    public interface ImdbApi {
        @POST("/authentication/credentials/temporary/android0702")
        Observable<GetTempCredentialsResponseOuter> getCredentials();

        @GET("/find")
        Observable<SearchNewResult> search(@Query("q") String q);
    }

    private static X509TrustManager xtm;

    private static SSLContext getSslContext() {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{xtm}, new SecureRandom());

        } catch (NoSuchAlgorithmException | KeyManagementException e) {
            e.printStackTrace();
        }
        return sslContext;
    }
}
