package com.cv.media.lib.imdb.zulu;

import android.util.Base64;

import org.apache.commons.io.Charsets;

import java.security.GeneralSecurityException;
import java.security.SignatureException;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class ZuluSignatureCalculator {
    private final PolicyType type;

    public ZuluSignatureCalculator() {
        this.type = PolicyType.ZuluApiPolicy;
    }

    private String encodeRawSignature(byte[] input) {
        // Base64.encodeToString(ra…EFAULT or Base64.NO_WRAP)
        return Base64.encodeToString(input, 2);
    }

    public String calculateSignature(byte[] corpus, String secretAccessKey) throws SignatureException {
        /*if (Intrinsics.areEqual((Object) this.type.getMacAlgorithm(), (Object) PolicyType.NONE) || Intrinsics.areEqual((Object) this.type.getKeySpecAlgorithm(), (Object) PolicyType.NONE)) {
            throw (Throwable) new RuntimeException("Attempting to calculate a signature with no crypto algorithm.");
        }*/
        try {
            //Intrinsics.checkExpressionValueIsNotNull(object, "type.macAlgorithm");
            PolicyType.CryptoAlgorithm macAlgorithm = this.type.getMacAlgorithm();
            // Mac mac = Mac.getInstance(macAlgorithm.name());
            Mac mac = Mac.getInstance("HmacSHA256");
            byte[] secretAccessKeyBytes = secretAccessKey.getBytes(Charsets.UTF_8);
            // Intrinsics.checkExpressionValueIsNotNull(secretAccessKey, "(this as java.lang.String).getBytes(charset)");
            PolicyType.CryptoAlgorithm keySpecAlgorithm = this.type.getKeySpecAlgorithm();
            // Intrinsics.checkExpressionValueIsNotNull((Object) cryptoAlgorithm, "type.keySpecAlgorithm");
            mac.init(new SecretKeySpec(secretAccessKeyBytes, keySpecAlgorithm.name()));
            byte[] result = mac.doFinal(corpus);
            // Intrinsics.checkExpressionValueIsNotNull(corpus, "mac.doFinal(corpus)");
            return this.encodeRawSignature(result);
        } catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException("Failed to generate crypto signature: " + generalSecurityException.getMessage());
        }
    }
}
