package com.cv.media.lib.imdb.adapter;

import android.text.TextUtils;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.cv.media.lib.imdb.model.SearchNewItem;
import com.cv.media.lib.imdb.model.SearchObject;

import java.lang.reflect.Type;

/**
 * Created by elegant.wang on 2018/1/8.
 */

public class SearchNewDeserializer implements JsonDeserializer<SearchObject> {
    // movie tvSeries
    @Override
    public SearchObject deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
         Class clazz = SearchObject.class;
        JsonObject jsonObject = json.getAsJsonObject();
        //if ((jsonObject.has("titleType") && isValidTitleType(jsonObject.get("titleType").getAsString())) || jsonObject.has("name")) {
        //    clazz = SearchNewItem.class;
        //}
        if (jsonObject.has("titleType") || jsonObject.has("name")) {
            clazz = SearchNewItem.class;
        }
        SearchObject searchObject = (SearchObject) new Gson().fromJson(json, clazz);
        return searchObject;
    }

    private boolean isValidTitleType(String titleType) {
        return TextUtils.equals("movie", titleType) || TextUtils.equals("tvSeries", titleType)
                || TextUtils.equals("tvMovie", titleType)|| TextUtils.equals("short", titleType)
                || TextUtils.equals("feature", titleType)|| TextUtils.equals("documentary", titleType)
                || TextUtils.equals("tv_series", titleType)|| TextUtils.equals("tvMiniSeries", titleType);
    }
}
