package com.cv.media.lib.imdb.zulu;

import com.cv.media.lib.imdb.model.ZuluTemporaryCredentials;
import com.cv.media.lib.imdb.utils.NameValuePairImpl;
import com.cv.media.lib.imdb.zulu.ZuluSignatureCalculator;

import org.apache.commons.lang3.StringUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.*;

public class ZuluSigner {
    ZuluSignatureCalculator signatureCalculator = new ZuluSignatureCalculator();

    private List<NameValuePairImpl> sortParameters(List<NameValuePairImpl> paramList) {
        paramList = new ArrayList(paramList);
        Collections.sort(paramList, new Comparator<NameValuePairImpl>() {
            @Override
            public int compare(NameValuePairImpl t1, NameValuePairImpl t2) {
                //todo
                return t1.getName().compareTo(t2.getName()) != 0 ? t1.getName().compareTo(t2.getName()) : t1.getValue().compareTo(t2.getValue());
            }
        });
        return paramList;
    }

    private String urlEncode(String paramString, boolean paramBoolean) {
        if (paramString == null) {
            paramString = "";
        }

        try {
            String str = URLEncoder.encode(paramString, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            paramString = str;
            if (paramBoolean) {
                paramString = str.replace("%2F", "/");
            }

            return paramString;
        } catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }

    }

    private String getCanonicalizedQueryString(List<NameValuePairImpl> paramList) {
        List<NameValuePairImpl> localObject1 = sortParameters(paramList);
        StringBuilder stringBuilder = new StringBuilder();

        for (int i = 0; i < localObject1.size(); i++) {
            NameValuePairImpl pair = localObject1.get(i);
            String str = pair.getName();
            String localObject2 = pair.getValue();
            stringBuilder.append(urlEncode(str, false));
            stringBuilder.append('=');
            stringBuilder.append(urlEncode(localObject2, false));
            if (i != localObject1.size() - 1) {
                stringBuilder.append('&');
            }
        }

        return stringBuilder.toString();
    }

    public Set<String> headerKeysOrdered(Map<String, String> paramMap) {
        TreeSet localTreeSet = new TreeSet();
        if (paramMap == null) {
            return localTreeSet;
        }
        localTreeSet.addAll(paramMap.keySet());
        return localTreeSet;
    }

    public String canonicalHeaders(Map<String, String> paramMap) {
        StringBuilder localStringBuilder = new StringBuilder();
        Iterator localIterator = headerKeysOrdered(paramMap).iterator();
        while (localIterator.hasNext()) {
            String str = (String) localIterator.next();
            localStringBuilder.append(str).append(':').append((String) paramMap.get(str)).append('\n');
        }
        return localStringBuilder.toString();
    }

    private String getCanonicalizedResourcePath(String paramString) {
        if ((paramString == null) || (paramString.length() == 0)) {
            paramString = "/";
            return paramString;
        }
        String str = urlEncode(paramString, true);
        if (!str.startsWith("/")) {
            str = "/" + str;
        }
        return str;
    }

    public String canonicalHeaderKeys(Map<String, String> paramMap) {
        return StringUtils.join(headerKeysOrdered(paramMap).toArray(), ";");
    }

    public byte[] hash(String paramString, byte[] paramArrayOfByte) {
        try {
            MessageDigest localMessageDigest = MessageDigest.getInstance("SHA-256");
            localMessageDigest.update(paramString.getBytes("UTF-8"));
            if (paramArrayOfByte != null) {
                localMessageDigest.update(paramArrayOfByte);
            }
            byte[] data = localMessageDigest.digest();
            return data;
        } catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        } catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public String sign(String host, String requestMethod, String resourcePath, Map<String, String> headers, List<NameValuePairImpl> paramList, byte[] postBody, ZuluTemporaryCredentials zuluTemporaryCredentials) {
        headers.put("host", host);
        String canonicalHeadersStr = canonicalHeaders(headers);
        String canonicalizedQueryString = getCanonicalizedQueryString(paramList);
        resourcePath = getCanonicalizedResourcePath(resourcePath);
        String signatureBody = requestMethod + '\n' + resourcePath + '\n' + canonicalizedQueryString + '\n' + canonicalHeadersStr + '\n';
        // Timber.i("signatureBody:%s", signatureBody);
        try {
            String signature = this.signatureCalculator.calculateSignature(hash(signatureBody, postBody), zuluTemporaryCredentials.getSecretAccessKey());
            StringBuilder sb = new StringBuilder();
            sb.append("AWS3 AWSAccessKeyId=").append(zuluTemporaryCredentials.getAccessKeyId()).append(',');
            sb.append("Algorithm=HmacSHA256,");
            sb.append("Signature=").append(signature).append(',');
            sb.append("SignedHeaders=").append(canonicalHeaderKeys(headers));
            return sb.toString();
        } catch (SignatureException signatureException) {
            throw new RuntimeException(signatureException);
        }
    }
}
