package com.cv.media.lib.imdb.model;

import android.text.TextUtils;

import com.google.gson.annotations.SerializedName;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by elegant.wang on 2018/1/8.
 */

public class SearchNewItem extends SearchObject {
    public static final Pattern constValidationPattern = Pattern.compile("[a-z][a-z]\\d{7,}");
    private String id;
    private String tconst;
    @SerializedName("titleType")
    private String type;
    private String title;
    private String name;
    private boolean connect;

    public boolean isConnect() {
        return connect;
    }

    public void setConnect(boolean connect) {
        this.connect = connect;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTconst() {
        if(TextUtils.isEmpty(tconst)) {
            try {
                Matcher matcher = constValidationPattern.matcher(id);
                if (matcher.find()) {
                    tconst = matcher.group();
                }
            } catch (Exception e) {
            }
        }
        return tconst;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTconst(String tconst) {
        this.tconst = tconst;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}
