package com.cv.media.lib.imdb.adapter;

import com.google.gson.*;
import com.cv.media.lib.imdb.model.ImdbMovieDetails;
import com.cv.media.lib.imdb.model.SearchObject;

import java.lang.reflect.Type;

/**
 * Created by elegant on 15/12/6.
 */
public class SearchDeserializer implements JsonDeserializer<SearchObject> {
    private final String TCONST = "tconst";
    private final String NCONST = "nconst";
    @Override
    public SearchObject deserialize(JsonElement json, Type typeOf, JsonDeserializationContext context)
            throws JsonParseException {
        //Log.d("elegant/SD",json.toString());
        //String searchObjectStr = json.getAsString();
        Class clazz = SearchObject.class;
        if(json.getAsJsonObject().has(TCONST)) {
            clazz = ImdbMovieDetails.class;
        }
        SearchObject searchObject = (SearchObject)new Gson().fromJson(json,clazz);
        return searchObject;
    }
}
