package com.cv.media.lib.imdb.zulu;

import com.cv.media.lib.common_utils.ntp.TrueTime;
import com.cv.media.lib.common_utils.utils.TimeUtils;
import com.cv.media.lib.imdb.model.ZuluTemporaryCredentials;
import com.cv.media.lib.imdb.utils.NameValuePairImpl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;

public class ZuluSigningInterceptor implements okhttp3.Interceptor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ZuluKey mZuluKey;
    ZuluSigner mZuluSigner;

    private ZuluSigningInterceptor() {
    }

    public ZuluSigningInterceptor(ZuluKey zuluKey, ZuluSigner zuluSigner) {
        mZuluKey = zuluKey;
        mZuluSigner = zuluSigner;
    }

    private Request sign(Request request) {
        ZuluTemporaryCredentials zuluTemporaryCredentials = mZuluKey.getZuluCredentials(false);
        String host = request.url().host();
        String method = request.method();
        String encodedPath = request.url().encodedPath();
        HashMap<String, String> headers = new HashMap<>();
        headers.put("host", host);
        String xAmzDate = TimeUtils.getFormattedRfc1123DateUtc(TrueTime.getInstance().now());
        if (!xAmzDate.endsWith("00:00")) {
            xAmzDate += "00:00";
        }
        headers.put("x-amz-date", xAmzDate);
        headers.put("x-amz-security-token", zuluTemporaryCredentials.getSessionToken());
        ArrayList<NameValuePairImpl> paramList = new ArrayList<>();
        for (String paramName : request.url().queryParameterNames()) {
            Iterator iterator2 = request.url().queryParameterValues(paramName).iterator();
            while (iterator2.hasNext()) {
                paramList.add(new NameValuePairImpl(paramName, iterator2.next().toString()));
            }
        }
        byte[] requestBody;
        try {
            Request tmpRequest = request.newBuilder().build();
            Buffer buffer = new Buffer();
            if (tmpRequest.body() != null) {
                tmpRequest.body().writeTo(buffer);
                requestBody = buffer.readUtf8().getBytes();
            } else {
                requestBody = null;
            }
        } catch (IOException iOException) {
            requestBody = null;
        }
        String sign = mZuluSigner.sign(host, method, encodedPath, headers, paramList, requestBody, zuluTemporaryCredentials);
        Request.Builder requestBuilder = request.newBuilder();
        requestBuilder.removeHeader("HOST");
        requestBuilder.header("User-Agent", "okhttp/3.8.0"); // 明确替换为3.8.0
        for (String keyName : headers.keySet()) {
            requestBuilder.addHeader(keyName, headers.get(keyName));
        }
        requestBuilder.addHeader("X-Amzn-Authorization", sign);
        return requestBuilder.build();
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        /*Response response = chain.proceed(sign(chain.request()));
        if (response.code() == 403) {
            mZuluKey.renew();
            Timber.e("imdb api 403, renew a zulukey and retry request");
            response = chain.proceed(sign(chain.request()));
        }
        return response;*/
        return process(chain, 3); // 增加重试
    }

    private Response process(Chain chain, int retryCnt) throws IOException {
        Response response = chain.proceed(sign(chain.request()));
        if (response.code() == 403 && retryCnt > 1) {
            //TimberUtils.e("imdb api 403, renew zulukey and retry. [%s]", response.body().string());
            mZuluKey.renew();
            retryCnt--;
            return process(chain, retryCnt);
        } else {
            return response;
        }
    }
}

