package com.cv.media.lib_keyboard;

import android.content.Context;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.EditText;

import com.cv.media.lib.common_utils.pool.ObjectPool;

import java.util.Locale;

public class MyKeyBoard {
    public enum Type {
        NUM,
        SYMBOLS,
        QWERTY_EN,
        QWERTY_ES,
        QWERTY_EN_EMAIL,
        QWERTY_EN_URL,
        QWERTY_ALL,
    }

    public static void configEditText(EditText editText, Type type) {
        editText.setShowSoftInputOnFocus(false);
        editText.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode == KeyEvent.KEYCODE_DPAD_CENTER && event.getAction() == KeyEvent.ACTION_DOWN) {
                    MyKeyBoard.showWith(editText, type);
                }
                return false;
            }
        });
    }

    public static void showWith(EditText editText, Type type) {
        KBView kb = null;
        if (type == Type.NUM) {
            //数字键盘
            kb = new NumKBV(editText.getContext());
        } else {
            if (Locale.getDefault().getLanguage().equals("es")) {
                //西语
            } else {
                //其他
            }
        }

        if (kb != null) {
            kb.show(editText);
        }
    }
}
