package com.cv.media.lib_keyboard;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.PixelFormat;
import android.graphics.drawable.ColorStateListDrawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.cv.media.lib.common_utils.provider.ContextProvider;

abstract class KBView extends RelativeLayout {
    static final int designHeight = 300;
    int realWidth;
    int realHeight;
    float ratio;

    {
        realWidth = ContextProvider.getContext().getResources().getDisplayMetrics().widthPixels;
        ratio = 1.0f * realWidth / baseWidth();
        realHeight = (int) (designHeight * ratio);
    }

    EditText editText;

    public KBView(Context context) {
        this(context, null);
    }

    public KBView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initLayout();
        setBackgroundColor(Color.GREEN);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(MeasureSpec.makeMeasureSpec(realWidth, MeasureSpec.AT_MOST), MeasureSpec.makeMeasureSpec(realHeight, MeasureSpec.AT_MOST));
        setMeasuredDimension(realWidth, realHeight);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
    }


    protected void initLayout() {
        IKey[][] keys = keys();
        View prevRow = null;
        View prev = null;
        for (int i = 0; i < keys.length; i++) {
            IKey[] keysInRow = keys[i];
            if (prev != null) prevRow = prev;
            prev = null;
            for (int j = 0; j < keysInRow.length; j++) {
                IKey key = keysInRow[j];
                TextView textView = new TextView(getContext());
                textView.setFocusableInTouchMode(true);
                textView.setId(View.generateViewId());
                textView.setTag(key);
                textView.setGravity(Gravity.CENTER);
                textView.setText(key.getDisplay());
                textView.setTextSize(8);
                textView.setTextColor(new ColorStateList(
                        new int[][]{
                                new int[]{android.R.attr.state_focused},
                                new int[]{android.R.attr.state_enabled}
                        },
                        new int[]{
                                Color.WHITE,
                                Color.BLACK
                        }));
                textView.setBackgroundResource(R.drawable.bg_key);
                textView.setOnClickListener(new OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        IKey k = (IKey) textView.getTag();
                        if (k != null) {
                            k.export(editText);
                        }
                    }
                });
                RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(0, 0);
                onLayoutParam(key, lp);
                lp.width = (int) (lp.width * ratio);
                lp.height = (int) (lp.height * ratio);
                lp.leftMargin = (int) (lp.leftMargin * ratio);
                lp.rightMargin = (int) (lp.rightMargin * ratio);
                lp.topMargin = (int) (lp.topMargin * ratio);
                lp.bottomMargin = (int) (lp.bottomMargin * ratio);
                if (prev != null) {
                    lp.addRule(RelativeLayout.RIGHT_OF, prev.getId());
                }
                if (prevRow != null) {
                    lp.addRule(RelativeLayout.BELOW, prevRow.getId());
                }
                addView(textView, lp);
                prev = textView;
                if (i == 0 && j == 0) textView.requestFocus();
            }
        }
    }

    public void show(EditText et) {
        editText = et;
        WindowManager windowManager = (WindowManager) et.getContext().getSystemService(Context.WINDOW_SERVICE);
        windowManager.addView(this, new WindowManager.LayoutParams(realWidth, realHeight, 0, et.getContext().getResources().getDisplayMetrics().heightPixels - realHeight, WindowManager.LayoutParams.TYPE_APPLICATION, WindowManager.LayoutParams.FLAG_LAYOUT_IN_SCREEN, PixelFormat.OPAQUE));
    }

    public void dismiss() {
        WindowManager windowManager = (WindowManager) editText.getContext().getSystemService(Context.WINDOW_SERVICE);
        windowManager.removeViewImmediate(this);
        editText = null;
    }

    protected int baseWidth() {
        return 1280;
    }

    abstract IKey[][] keys();

    abstract void onLayoutParam(IKey key, RelativeLayout.LayoutParams lp);

    public void setEditText(EditText editText) {
        this.editText = editText;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == KeyEvent.KEYCODE_BACK && event.getAction() == KeyEvent.ACTION_DOWN) {
            dismiss();
            return true;
        }
        return super.dispatchKeyEvent(event);
    }
}
