package com.cv.media.lib.log;

import android.content.Context;
import android.util.Log;

import com.dianping.logan.Logan;
import com.dianping.logan.LoganConfig;
import com.dianping.logan.SendLogRunnable;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 初始化，打印/保存日志，获取日志文件
 */
public class Logger {

    private static boolean showDebugLog = false;

    /**
     * 初始化日志库
     *
     * @param context
     */
    public static void init(Context context) {
        if (context == null) {
            Log.e("Logger", "init logger failed, context is null");
            return;
        }
        try {
            LoganConfig config = new LoganConfig.Builder()
                    .setCachePath(context.getApplicationContext().getExternalCacheDir().getAbsolutePath())
                    .setPath(context.getApplicationContext().getExternalFilesDir(null).getAbsolutePath()
                            + File.separator + "log")
                    .setEncryptKey16("0123456789012345".getBytes())//日志文件加密key
                    .setEncryptIV16("0123456789012345".getBytes())
                    .setDay(15)//保存3天日志
                    .setMaxFile(10)//每天日志保存10m
                    .build();
            Logan.init(config);
        } catch (Exception e) {
            Log.e("Logger", "init logger failed !", e);
        }
    }

    public static void showDebugLog(boolean isDebug) {
        showDebugLog = isDebug;
    }

    public static void v(String tag, String msg) {
        if (showLogcat(Log.VERBOSE)) {
            Log.v(tag, msg);
        }
//        saveLog(msg, Log.VERBOSE);
    }

    public static void v(String tag, String format, Object... params) {
        v(tag, getFormat(format, params));
    }

    public static void d(String tag, String msg) {
        if (showLogcat(Log.DEBUG)) {
            Log.d(tag, msg);
        }
//        saveLog(msg, Log.DEBUG);
    }

    public static void d(String tag, String format, Object... params) {
        d(tag, getFormat(format, params));
    }

    public static void i(String tag, String msg) {
        if (showLogcat(Log.INFO)) {
            Log.i(tag, msg);
        }
        saveLog(msg, Log.INFO);
    }

    public static void i(String tag, String format, Object... params) {
        i(tag, getFormat(format, params));
    }

    public static void w(String tag, String msg) {
        if (showLogcat(Log.WARN)) {
            Log.w(tag, msg);
        }
        saveLog(msg, Log.WARN);
    }

    public static void w(String tag, String format, Object... params) {
        w(tag, getFormat(format, params));
    }

    public static void e(String tag, String msg) {
        if (showLogcat(Log.ERROR)) {
            Log.e(tag, msg);
        }
        saveLog(msg, Log.ERROR);
    }

    public static void e(String tag, String format, Object... params) {
        e(tag, getFormat(format, params));
    }

    /**
     * 获取当天的日志
     *
     * @param listener
     */
    public static void getTodayLogFile(final ReadLogFileListener listener) {
        try {
            //若没有当天日志，则不会触发SendLogRunnable回调
            SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd");
            String d = dataFormat.format(new Date(System.currentTimeMillis()));
            Logan.s(new String[]{d}, new SendLogRunnable() {
                @Override
                public void sendLog(File logFile) {
                    if (listener != null) {
                        listener.readLog(logFile);
                    }
                    // Must Call finish after send log
                    finish();
                }
            });
        } catch (Exception e) {
            Log.d("Logger", "getTodayLogFile error !", e);
        }
    }

    /**
     * 获取所有的日志
     *
     * @param listener
     */
    public static void getAllLogFile(final ReadLogFileListener listener) {
        try {
            //若没有当天日志，则不会触发SendLogRunnable回调
            Map<String, Long> fileInfo = Logan.getAllFilesInfo();
            String[] dates = (String[]) fileInfo.keySet().toArray();
            Logan.s(dates, new SendLogRunnable() {
                @Override
                public void sendLog(File logFile) {
                    if (listener != null) {
                        listener.readLog(logFile);
                    }
                    // Must Call finish after send log
                    finish();
                }
            });
        } catch (Exception e) {
            Log.d("Logger", "getAllLogFile error !", e);
        }
    }

    /**
     * 日志上传时机由外部决定
     *
     * @param url
     * @param date
     * @param headers
     */
    public static void sendToServer(String url, String date, HashMap<String, String> headers, SendLogListener listener) {
        Logan.s(url, date, headers, (statusCode, data) -> {
            if (listener != null) {
                listener.sendStatus(statusCode == 200);
            }
        });
    }


    public static List<File> getAllLogFile(Context context) {
        try {
            File dir = new File(context.getApplicationContext().getExternalFilesDir(null).getAbsolutePath()
                    + File.separator + "log");
            if (!dir.exists()) {
                return null;
            }
            File[] files = dir.listFiles();
            if (files == null) {
                return null;
            }
            return Arrays.asList(files);
        } catch (Exception e) {
        }
        return null;
    }


    //是否显示日志在logcat
    private static boolean showLogcat(int level) {
        if (showDebugLog) {
            return true;
        }
        if (level >= Log.INFO) {
            return true;
        }
        return false;
    }

    //保存日志
    private static void saveLog(String log, int type) {
        try {
            Logan.w(log, type);
        } catch (Exception e) {
            //ignore
//            e.printStackTrace();
        }
    }

    private static String getFormat(String format, Object... params) {
        try {
            if (params == null || params.length == 0)
                return format;
            return String.format(format, params);
        } catch (Exception e) {
            return format;
        }
    }
}
