package com.cv.media.lib.metric.devmetric;

import android.text.TextUtils;

import com.cv.media.lib.common_utils.ntp.TrueTime;
import com.metric.agent2.MetricAgent;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zhangyaoa on 2020/10/26.
 */
public class MetricAgentManager {
    public static HashMap<String, HashMap<String, Object>> mEventMap = new HashMap<>();

    public static HashMap<String, String> mCommonTagMap = new HashMap<>();

    public static void startQueueEvent(String eventId, String eventKey, Object eventValue) {
        HashMap<String, Object> eventDetailMap = new HashMap<>();
        eventDetailMap.put("localStartTime", TrueTime.getInstance().currentTimeMillis());
        if (eventKey != null && eventValue != null) {
            eventDetailMap.put(eventKey, eventValue);
        }
        mEventMap.put(eventId, eventDetailMap);
    }

    public static void updateQueueEvent(String eventId, String eventKey, Object eventValue) {
        HashMap<String, Object> eventDetailMap = mEventMap.get(eventId);
        if (eventDetailMap != null && eventKey != null && eventValue != null) {
            eventDetailMap.put(eventKey, eventValue);
        }
    }

    public static void finishQueueEvent(String eventId) {
        try {
            if (TextUtils.isEmpty(eventId)) {
                return;
            }

            HashMap<String, Object> eventDetailMap = mEventMap.get(eventId);
            if (eventDetailMap == null || eventDetailMap.isEmpty()) {
                return;
            }

            eventDetailMap.put("localEndTime", TrueTime.getInstance().currentTimeMillis());
            eventDetailMap.putAll(commonTagMap());
            MetricAgent.postEvent(eventId, null, eventDetailMap);
            removeEvent(eventId);
        } catch (Throwable e) {
            e.printStackTrace();
        }
    }


    public static void postSingleEvent(String eventId, String eventKey, Object eventValue) {
        try {
            HashMap<String, Object> eventMap = new HashMap<>();
            if (eventKey != null && eventValue != null) {
                eventMap.put(eventKey, eventValue);
            }
            eventMap.putAll(commonTagMap());
            MetricAgent.postEvent(eventId, null, eventMap);
        } catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void postEvents(String eventId, HashMap<String, Object> events) {
        try {
            events.putAll(commonTagMap());
            MetricAgent.postEvent(eventId, null, events);
        } catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static HashMap<String, String> commonTagMap() {
        return mCommonTagMap;
    }

    public static void init(HashMap<String, String> commonParams, String appId, String appKey, String host) {
        MetricAgent.init(appId, appKey, host);

        if (commonParams != null && !commonParams.isEmpty()) {
            mCommonTagMap.putAll(commonParams);
        }
    }

    //有一些公共参数需要在登录等非初始化时机更新
    public static void updateCommonParams(HashMap<String, String> commonParams) {
        if (commonParams != null && !commonParams.isEmpty()) {
            mCommonTagMap.putAll(commonParams);
        }
    }

    public static void postEvents(String eventId, Map<String, String> tagMap, Map<String, Object> fieldMap) {
        try {
            MetricAgent.postEvent(eventId, tagMap, fieldMap);
        } catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void removeEvent(String eventId) {
        mEventMap.remove(eventId);
    }

    private static void clearData() {
        mEventMap.clear();
    }
}
