package com.cv.media.lib.metric.data;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MetricData {

    private Map<String, Object> dataMap = new LinkedHashMap<>();

    private MetricData() {
    }

    public Map<String, Object> value() {
        return dataMap;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        MetricData metricData;

        public Builder() {
            metricData = new MetricData();
        }

        Builder(MetricData data) {
            metricData = data;
        }

        public Builder put(String key, Object value) {
            metricData.dataMap.put(key, value);
            return this;
        }

        public Builder put(Map<String, Object> m) {
            metricData.dataMap.putAll(m);
            return this;
        }

        public MetricData build() {
            return metricData;
        }
    }
}
