package com.cv.media.lib.mvx.compArch;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.os.Process;
import android.os.Trace;
import android.util.Log;

import androidx.annotation.NonNull;

import com.vod.android.arouter.launcher.ARouter;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.cv.media.lib.common_utils.BuildConfig;
import com.cv.media.lib.common_utils.appinit.IInitializationNormalTask;
import com.cv.media.lib.common_utils.appinit.Initialization;

public abstract class HostApplication extends Application {
    final Set<Application> mApplications = new HashSet<>();
    boolean refMainProcess = true;

    protected abstract List<Class> modulesService();

    protected boolean isMainProcess() {
        return refMainProcess;
    }

    @Override
    protected void attachBaseContext(Context base) {
        try {
            refMainProcess = base.getPackageName().equals(getCurrentProcessName(base));
        } catch (Exception ignore) {
            ignore.printStackTrace();
        }

        if (isMainProcess() && BuildConfig.DEBUG) {
            Log.v(HostApplication.class.getSimpleName(), "attachBaseContext start");
            Trace.beginSection(HostApplication.this.getClass().getName() + " attachBaseContext");
        }

        super.attachBaseContext(base);

        if (!isMainProcess()) return;

        if (BuildConfig.DEBUG) {
            ARouter.openDebug();
            ARouter.openLog();
        }


        if (BuildConfig.DEBUG) {
            Log.v(HostApplication.class.getSimpleName(), "attachBaseContext end");
            Trace.endSection();
        }
    }

    @Override
    public void onCreate() {
        if (isMainProcess() && BuildConfig.DEBUG) {
            Log.v(HostApplication.class.getSimpleName(), "onCreate start");
            Trace.beginSection(HostApplication.this.getClass().getName() + " onCreate");
        }

        super.onCreate();

        if (!isMainProcess()) return;

        ARouter.init(this);

        List<Class> moduleServices = modulesService();
        if (moduleServices != null) {
            for (Class clz : moduleServices) {
                try {
                    Class appClz = ((IModuleService) ARouter.getInstance().navigation(clz)).application();
                    if (appClz != null) {
                        mApplications.add((Application) appClz.newInstance());
                    } else {
                        Log.w(HostApplication.class.getSimpleName(), "moduleService: " + clz.getSimpleName() + " has no implementation");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        //暂时将子模块的attachBaseContext放在onCreate来做
        //Todo: 因D8/R8 主Dex计算路径, 需要修改Arouter库来将 Page和Service做注册分离, 现在都是捆在一起, 会导致大量类被计入主包
        try {
            Method method_AttachCtx = ContextWrapper.class.getDeclaredMethod("attachBaseContext", Context.class);
            method_AttachCtx.setAccessible(true);
            for (Application application : mApplications) {
                try {
                    if (BuildConfig.DEBUG)
                        Trace.beginSection(application.getClass().getName() + " attachBaseContext");
                    method_AttachCtx.invoke(application, getApplicationContext());
                    if (BuildConfig.DEBUG) Trace.endSection();
                } catch (Exception ignore) {
                }
            }
        } catch (Exception e) {
            mApplications.clear();
            e.printStackTrace();
        }

        try {
            Field field_cbs = Application.class.getDeclaredField("mActivityLifecycleCallbacks");
            field_cbs.setAccessible(true);
            for (Application application : mApplications) {
                try {
                    if (BuildConfig.DEBUG) {
                        Trace.beginSection(application.getClass().getName() + " onCreate");
                        Log.v(HostApplication.class.getSimpleName(), "sub module start: " + application.getClass().getSimpleName());
                    }
                    application.onCreate();
                    if (BuildConfig.DEBUG) {
                        Log.v(HostApplication.class.getSimpleName(), "sub module end: " + application.getClass().getSimpleName());
                        Trace.endSection();
                    }
                    ArrayList<ActivityLifecycleCallbacks> cbs = (ArrayList<ActivityLifecycleCallbacks>) field_cbs.get(application);
                    for (ActivityLifecycleCallbacks cb : cbs) {
                        registerActivityLifecycleCallbacks(cb);
                    }
                    cbs.clear();
                } catch (Exception ignore) {
                    ignore.printStackTrace();
                }
            }
           if (initializationBoost()) Initialization.getInstance().startProceed(IInitializationNormalTask.class);
        } catch (Exception ignore) {
            ignore.printStackTrace();
        }

        if (BuildConfig.DEBUG) {
            Log.v(HostApplication.class.getSimpleName(), "onCreate end");
            Trace.endSection();
        }
    }

    protected boolean initializationBoost() {
        return true;
    }

    @Override
    public void onLowMemory() {
        super.onLowMemory();
        for (Application application : mApplications) {
            application.onLowMemory();
        }
    }

    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        for (Application application : mApplications) {
            application.onConfigurationChanged(newConfig);
        }
    }

    public static String getCurrentProcessName(Context context) {
        ActivityManager activityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        if (activityManager == null) {
            return null;
        }
        for (ActivityManager.RunningAppProcessInfo processInfo : activityManager.getRunningAppProcesses()) {
            if (processInfo.pid == Process.myPid()) {
                return processInfo.processName;
            }
        }
        return null;
    }
}
