package com.cv.media.lib.planet;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.RenderNode;
import android.util.AttributeSet;
import android.view.Choreographer;
import android.view.View;
import android.view.ViewGroup;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
/**
* 顶节点
* 职责:
 * 1. 接收 脏边界
 * 2. 管理 数据计算的过程
 * 3. 进阶: 实现异步计算
* @author Damon
*/
class RootNode extends ViewGroup {
    final List<BoundaryNode> dirty = new ArrayList<>();
    final List<BoundaryNode> temp = new ArrayList<>();
    IDirtyProcessor processor = new SyncDP();
     boolean fullProcedure = false;

    public RootNode(Context context) {
        super(context);
    }

    public RootNode(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    void requestLayout(BoundaryNode boundaryNode) {
        if (fullProcedure) {
            dirty.add(boundaryNode);
        }

        super.requestLayout();
    }

    @Override
    public void forceLayout() {
        super.forceLayout();
        fullProcedure = false;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        //这里开始处理脏边界
        //1.同步 2.异步
        if (fullProcedure) {
            temp.clear();
            temp.addAll(dirty);
            processor.process(temp);
            dirty.clear();
        }else {
            measureChildren(widthMeasureSpec, heightMeasureSpec);
        }
        View child = getChildAt(0);
        setMeasuredDimension(child.getMeasuredWidth(), child.getMeasuredHeight());
    }

    @Override
    protected void onLayout(boolean b, int i, int i1, int i2, int i3) {
        if (!fullProcedure) {
            fullProcedure = true;
            View view = getChildAt(0);
            view.layout(0,0,  view.getMeasuredWidth(), view.getMeasuredHeight());
        }
    }

}
