package com.cv.media.lib.planet;

import android.view.View;
import android.view.ViewGroup;

import java.util.List;

class SyncDP implements IDirtyProcessor {
    @Override
    public void process(List<BoundaryNode> boundaryNodes) {
        for (BoundaryNode boundaryNode : boundaryNodes) {
            ViewGroup parent = (ViewGroup) boundaryNode.getParent();
            int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(parent.getMeasuredWidth(), View.MeasureSpec.AT_MOST);
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(parent.getMeasuredHeight(), View.MeasureSpec.AT_MOST);
            boundaryNode.measure(ViewGroup.getChildMeasureSpec(widthMeasureSpec, 0, boundaryNode.getLayoutParams().width), ViewGroup.getChildMeasureSpec(heightMeasureSpec, 0, boundaryNode.getLayoutParams().height));
            boundaryNode.layout(boundaryNode.getLeft(), boundaryNode.getTop(), boundaryNode.getLeft() + boundaryNode.getMeasuredWidth(), boundaryNode.getBottom());
        }
    }
}
