package com.cv.media.lib.planet;

import android.view.View;
import android.view.ViewGroup;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

class AsyncDP implements IDirtyProcessor{
    static ExecutorService executorService = Executors.newFixedThreadPool(4);
    static AtomicInteger workingCount = new AtomicInteger(0);

    @Override
    public void process(List<BoundaryNode> boundaryNodes) {
        workingCount.set(boundaryNodes.size());
        for (BoundaryNode boundaryNode : boundaryNodes) {
            executorService.execute(new Runnable() {
                @Override
                public void run() {
                    ViewGroup parent = (ViewGroup) boundaryNode.getParent();
                    int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(parent.getMeasuredWidth(), View.MeasureSpec.AT_MOST);
                    int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(parent.getMeasuredHeight(), View.MeasureSpec.AT_MOST);
                    boundaryNode.measure(ViewGroup.getChildMeasureSpec(widthMeasureSpec, 0, boundaryNode.getLayoutParams().width), ViewGroup.getChildMeasureSpec(heightMeasureSpec, 0, boundaryNode.getLayoutParams().height));
                    boundaryNode.layout(boundaryNode.getLeft(), boundaryNode.getTop(), boundaryNode.getLeft() + boundaryNode.getMeasuredWidth(), boundaryNode.getBottom());
                    workingCount.decrementAndGet();
                }
            });
        }
    }
}
