package com.cv.media.lib.planet;

import android.util.Pair;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import com.cv.media.lib.common_utils.callback.ICallBack;
import com.cv.media.lib.common_utils.utils.UiUtils;

public class Planet {
    private static int TAG = 0x64 << 24;

    public static View transform(ViewGroup vp) {
        RootNode rootNode = new RootNode(vp.getContext());
        UiUtils.traversalViewWithIndex(vp, new ICallBack<Pair<View, Integer>>() {
            @Override
            public void call(Pair<View, Integer> viewIntegerPair) {
                View view = viewIntegerPair.first;
                int index = viewIntegerPair.second;
                if (view instanceof ViewGroup) {
                    ViewGroup vParent = (ViewGroup) view.getParent();
                    if (view.getLayoutParams().width > 0 && view.getLayoutParams().height > 0) {
                        BoundaryNode boundaryNode = new BoundaryNode(view.getContext());
                        boundaryNode.setRootNode(rootNode);
                        boundaryNode.setLayoutParams(view.getLayoutParams());
                        view.setLayoutParams(new ViewGroup.LayoutParams(view.getLayoutParams().width, view.getLayoutParams().height));
                        vParent.removeViewAt(index);
                        vParent.addView(boundaryNode, index);
                        boundaryNode.addView(view);

                        if (vParent instanceof RelativeLayout && boundaryNode.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
                            //相对布局, 有改Id的需求
                            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams) boundaryNode.getLayoutParams();
                            for (int i = 0; i < lp.getRules().length; i++) {
                                int id = lp.getRules()[i];
                                if (id > 0) {
                                    View tmp = vParent.findViewById(id);
                                    if (tmp instanceof ViewGroup && tmp.getLayoutParams().width > 0 && tmp.getLayoutParams().height > 0) {
                                        int boundaryId;
                                        if (tmp.getParent() instanceof BoundaryNode) {
                                            //已经嵌入
                                            boundaryId = ((BoundaryNode) tmp.getParent()).getId();
                                        } else {
                                            //未嵌入
                                            boundaryId = View.generateViewId();
                                            tmp.setTag(TAG, boundaryId);
                                        }
                                        lp.getRules()[i] = boundaryId;
                                    }
                                }
                            }

                            if (view.getTag(TAG) != null) {
                                boundaryNode.setId((Integer) view.getTag(TAG));
                            }else {
                                boundaryNode.setId(View.generateViewId());
                            }
                        }
                    }
                }
            }
        });

        rootNode.addView(vp, new ViewGroup.LayoutParams(vp.getLayoutParams().width, vp.getLayoutParams().height));
        rootNode.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT));
        return rootNode;
    }
}
