package com.cv.media.lib.planet;

import android.content.Context;
import android.graphics.RenderNode;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;


class BoundaryNode extends ViewGroup {
    RootNode rootNode;

    public BoundaryNode(Context context) {
        super(context);
    }

    public BoundaryNode(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setRootNode(RootNode rootNode) {
        this.rootNode = rootNode;
    }


    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
       setMeasuredDimension(getLayoutParams().width, getLayoutParams().height);
        measureChildren(MeasureSpec.makeMeasureSpec(getMeasuredWidth(), MeasureSpec.AT_MOST), MeasureSpec.makeMeasureSpec(getMeasuredHeight(), MeasureSpec.AT_MOST));
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        View view = getChildAt(0);
        view.layout(0,0, view.getMeasuredWidth(), view.getMeasuredHeight());
    }


    @Override
    public void requestLayout() {
        if (rootNode != null) {
            rootNode.requestLayout(this);
            forceLayout();
            return;
        }
        super.requestLayout();
    }

    @Override
    public void onDescendantInvalidated(@NonNull View child, @NonNull View target) {
        super.onDescendantInvalidated(child, target);
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }
}
