package com.cv.media.lib.plugin;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;

import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;

public class MyResources extends Resources {

    private Context mContext;
    private Resources defaultResources;
    private ResourcesPlugin pluginResources;

    public MyResources(Context context, Resources defaultResources, ResourcesPlugin resourcesPlugin) {
        super(defaultResources.getAssets(), defaultResources.getDisplayMetrics(), defaultResources.getConfiguration());
        this.mContext = context;
        this.pluginResources = resourcesPlugin;
        this.defaultResources = defaultResources;
    }

    /*
    @NonNull
    @Override
    public String getString(int id) throws NotFoundException {
        String entryName = defaultResources.getResourceEntryName(id);
        String entryValue = null;
        if (!TextUtils.isEmpty(entryName)) {
            int resId = getResourceId("string", entryName);
            try {
                entryValue = pluginResources.resources.getString(resId);
            } catch (Exception e) {
                Log.e("", e.getMessage());
            }
        }

        if (TextUtils.isEmpty(entryValue)) {
            entryValue = super.getString(id);
        }
        return entryValue;
    }
     */

    @NonNull
    @Override
    public CharSequence getText(@StringRes int id) {
        String entryName = defaultResources.getResourceEntryName(id);
        CharSequence entryValue = null;
        if (!TextUtils.isEmpty(entryName)) {
            int resId = getResourceId("string", entryName);
            try {
                entryValue = pluginResources.resources.getText(resId);
            } catch (Exception e) {
                Log.e("", e.getMessage());
            }
        }

        if (TextUtils.isEmpty(entryValue)) {
            entryValue = super.getText(id);
        }
        return entryValue;
    }

    /*
    @NonNull
    @Override
    public Drawable getDrawable(@DrawableRes int id) {
        String entryName = defaultResources.getResourceEntryName(id);
        int resId = getResourceId("drawable", entryName);
        if (0 == resId) {
            return defaultResources.getDrawable(id);
        } else {
            Drawable drawable = pluginResources.resources.getDrawable(resId);
            if (null == drawable) {
                return defaultResources.getDrawable(id);
            }
            return drawable;
        }
    }

    @NonNull
    @Override
    public ColorStateList getColorStateList(@ColorRes int id) throws NotFoundException {
        String entryName = defaultResources.getResourceEntryName(id);
        int resId = getResourceId("color", entryName);
        if (0 == resId) {
            return defaultResources.getColorStateList(id);
        } else {
            ColorStateList colorStateList = pluginResources.resources.getColorStateList(resId);
            if (null == colorStateList) {
                return defaultResources.getColorStateList(id);
            }
            return colorStateList;
        }
    }

    @NonNull
    @Override
    public int getColor(@ColorRes int id) {
        String entryName = defaultResources.getResourceEntryName(id);
        int resId = getResourceId("color", entryName);
        if (0 == resId) {
            return defaultResources.getColor(id);
        } else {
            int color = pluginResources.resources.getColor(resId);
            if (0 == color) {
                return defaultResources.getColor(id);
            }
            return color;
        }
    }

    @NonNull
    @Override
    public XmlResourceParser getLayout(@LayoutRes int id) throws NotFoundException {
        String entryName = defaultResources.getResourceEntryName(id);
        int resId = getResourceId("layout", entryName);
        if (0 == resId) {
            return defaultResources.getLayout(id);
        } else {
            XmlResourceParser xmlResourceParser = pluginResources.resources.getLayout(resId);
            if (null == xmlResourceParser) {
                return defaultResources.getLayout(id);
            }
            return xmlResourceParser;
        }
    }
     */

    /**
     * 从资源插件里根据名称类型获取id
     *
     * @param fieldName
     * @param type
     * @return resId
     */
    public int getResourceId(String type, String fieldName) {
        int resId = 0;
        if (null != pluginResources) {
            try {
                resId = pluginResources.resources.getIdentifier(fieldName, type, pluginResources.packageName);
            } catch (Exception e) {
                //e.printStackTrace();
                return 0;
            }
        }
        return resId;
    }

//    @Override
//    public TypedArray obtainAttributes(AttributeSet set, int[] attrs) {
//        TypedArray mTypedArray = pluginResources.resources.obtainAttributes(set, attrs);
//        return mTypedArray;
//    }
//
//    @NonNull
//    @Override
//    public TypedArray obtainTypedArray(int id) throws NotFoundException {
//        TypedArray mTypedArray = pluginResources.resources.obtainTypedArray(id);
//        return mTypedArray;
//    }
}
