package com.cv.media.lib.utils;

import android.content.Context;
import android.text.TextUtils;

import androidx.core.content.ContextCompat;

import com.cv.media.lib.plugin.ResourceManager;

import java.io.File;

public class PluginUtils {
    public static void deletePluginFile(Context context) {
        File apkDir = new File(ContextCompat.getDataDir(context).getAbsolutePath() + ResourceManager.RES_PLUGIN_PATH_OTA);
        if (null != apkDir && apkDir.exists()) {
            deleteFile(apkDir,true);
        }
        File dexDir = context.getDir("plugin", Context.MODE_PRIVATE);
        if (dexDir.exists()) {
            deleteFile(dexDir,true);
        }
    }

    private static void deleteFile(File file, boolean deleteThisPath) {
        if (null != file) {
            try {
                if (file.isDirectory()) { //目录
                    File files[] = file.listFiles();
                    for (int i = 0; i < files.length; i++) {
                        deleteFile(new File(files[i].getAbsolutePath()), true);
                    }
                }
                if (deleteThisPath) {
                    if (!file.isDirectory()) { //如果是文件，删除
                        file.delete();
                    } else { //目录
                        if (file.listFiles().length == 0) { //目录下没有文件或者目录，删除
                            file.delete();
                        }
                    }
                }
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }
}
