package com.cv.media.lib.factory;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.cv.media.lib.log.Logger;
import com.cv.media.lib.storage.mmkv.CommonPreference;

import java.util.ArrayList;
import java.util.List;

public class ResFactory implements LayoutInflater.Factory {

    private List<ResItem> resItems = new ArrayList<>();

    @Nullable
    @Override
    public View onCreateView(@NonNull String name, @NonNull Context context, @NonNull AttributeSet attrs) {
        //Logger.d("plugin", "------name = " + name);
        for (int i = 0; i < attrs.getAttributeCount(); i++) {
            //Logger.d("plugin", "------name.attrs = " + attrs.getAttributeName(i));
        }
        View view = createView(name, context, attrs);
        if (view != null) {
            //Logger.d("plugin", "------view != null");
            collectViewAttr(view, context, attrs);
        }
        return view;
    }

    private View createView(String name, Context context, AttributeSet attrs) {
        View view = null;
        try {
            if (-1 == name.indexOf('.')) {// no "." is system view
                if ("View".equals(name)) {
                    view = LayoutInflater.from(context).createView(name, "android.view.", attrs);
                }
                if (view == null) {
                    //Logger.d("plugin", "------android.widget.");
                    view = LayoutInflater.from(context).createView(name, "android.widget.", attrs);
                }
                if (view == null) {
                    //Logger.d("plugin", "------android.webkit.");
                    view = LayoutInflater.from(context).createView(name, "android.webkit.", attrs);
                }
//                if (view == null) {
//                    //Logger.d("plugin", "------androidx.preference.");
//                    view = LayoutInflater.from(context).createView(name, "androidx.preference.", attrs);
//                }
            } else {// custom view
                //Logger.d("plugin", "------custom view");
                view = LayoutInflater.from(context).createView(name, null, attrs);
            }
        } catch (Exception e) {
            view = null;
        }
        return view;
    }

    private void collectViewAttr(View view, Context context, AttributeSet attrs) {
        List<ResAttr> resAttrs = new ArrayList<>();
        int attCount = attrs.getAttributeCount();
        for (int i = 0; i < attCount; ++i) {
            String attributeName = attrs.getAttributeName(i);
            String attributeValue = attrs.getAttributeValue(i);
            //Logger.d("plugin", "------attributeName/attributeValue = " + attributeName + "/" + attributeValue);
            if (isSupportedAttr(attributeName)) {
                //Logger.d("plugin", "------is supported");
                if (attributeValue.startsWith("@")) {
                    //Logger.d("plugin", "------startsWith @");
                    int resId = Integer.parseInt(attributeValue.substring(1));
                    //Logger.d("plugin", "------resId = " + resId);
                    if (resId > 0) {
                        try {
                            String resName = context.getResources().getResourceEntryName(resId);
                            String attrType = context.getResources().getResourceTypeName(resId);
                            //Logger.d("plugin", "------resName/attrType = " + resName + "/" + attrType);
                            resAttrs.add(new ResAttr(attributeName, attrType, resName, resId));
                        } catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }
        if (resAttrs.size() > 0) {
            ResItem resItem = new ResItem(view, resAttrs);
            // update now
            resItem.apply();
            resItems.add(resItem);
        }

    }

    private boolean isSupportedAttr(String attributeName) {
        return "text".equals(attributeName) || "title".equals(attributeName);
        //return "background".equals(attributeName) || "textColor".equals(attributeName) || "src".equals(attributeName);
    }

    public void apply() {
        Logger.d("plugin", "------resItems.size() = " + resItems.size());
        if (null == resItems || 0 == resItems.size()) {
            return;
        }
        if (CommonPreference.getInstance().getBoolean("resource_need_update", false)) {
            Logger.d("plugin", "------resource_need_update, true");
            CommonPreference.getInstance().putBoolean("resource_need_update", false);
            for (ResItem item : resItems) {
                item.apply();
            }
        }
    }

    public void clear() {
        resItems.clear();
    }
}
