package com.cv.media.lib.plugin;

import android.content.res.AssetManager;
import android.os.Build;



import java.io.File;
import java.lang.reflect.Method;

public class AssetEngine {

    private static final String TAG = AssetEngine.class.getSimpleName();

    private static AssetManager mAssetManager;

    public static AssetManager initAssetManager(File apkFile) throws Exception {
        mAssetManager = AssetManager.class.newInstance();
        Method addAssetPathMethod = AssetManager.class.getDeclaredMethod("addAssetPath", String.class);
        addAssetPathMethod.setAccessible(true);
        int result = (int) addAssetPathMethod.invoke(mAssetManager, apkFile.getAbsolutePath());
        if (Build.VERSION.SDK_INT <= 26) {
            Method ensureStringBlocksMethod = AssetManager.class.getDeclaredMethod("ensureStringBlocks");
            ensureStringBlocksMethod.setAccessible(true);
            ensureStringBlocksMethod.invoke(mAssetManager);
        }
        //resource = new Resources(mAssetManager, getResources().getDisplayMetrics(), getResources().getConfiguration());
        return mAssetManager;
    }
}
