package com.cv.media.lib.factory;

import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;


import com.cv.media.lib.plugin.ResourceManager;

import java.util.List;

public class ResItem {

    private View view;

    private List<ResAttr> attrs;

    public ResItem(View view, List<ResAttr> attrs) {
        this.view = view;
        this.attrs = attrs;
    }

    public void apply() {
        if (view == null || attrs == null) {
            return;
        }
        for (ResAttr attr : attrs) {
            String attrName = attr.getAttrName();
            String attrType = attr.getAttrType();
            String resName = attr.getResName();
            int resId = attr.getResId();
            if ("text".equals(attrName) || "title".equals(attrName)) {
                setText(resName, resId);
            }
        }
    }

    private void setText(String resName, int resId) {
        String str = ResourceManager.getInstance().getText(resName);
        //Log.d("plugin", "------setText() = " + str);
        if (!TextUtils.isEmpty(str)) {
            ((TextView) view).setText(str);
        }
    }
}
