package com.cv.media.lib.factory;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;


import com.cv.media.lib.storage.mmkv.CommonPreference;

import java.util.ArrayList;
import java.util.List;

public class ResFactory implements LayoutInflater.Factory {

    private List<ResItem> resItems = new ArrayList<>();

    @Nullable
    @Override
    public View onCreateView(@NonNull String name, @NonNull Context context, @NonNull AttributeSet attrs) {
        //Log.d("plugin", "------name = " + name);
        for (int i = 0; i < attrs.getAttributeCount(); i++) {
            //Log.d("plugin", "------name.attrs = " + attrs.getAttributeName(i));
        }
        View view = createView(name, context, attrs);
        if (view != null) {
            //Log.d("plugin", "------view != null");
            collectViewAttr(view, context, attrs);
        }
        return view;
    }

    private View createView(String name, Context context, AttributeSet attrs) {
        View view = null;
        try {
            if (-1 == name.indexOf('.')) {// no "." is system view
                if ("View".equals(name)) {
                    view = LayoutInflater.from(context).createView(name, "android.view.", attrs);
                }
                if (view == null) {
                    //Log.d("plugin", "------android.widget.");
                    view = LayoutInflater.from(context).createView(name, "android.widget.", attrs);
                }
                if (view == null) {
                    //Log.d("plugin", "------android.webkit.");
                    view = LayoutInflater.from(context).createView(name, "android.webkit.", attrs);
                }
//                if (view == null) {
//                    //Log.d("plugin", "------androidx.preference.");
//                    view = LayoutInflater.from(context).createView(name, "androidx.preference.", attrs);
//                }
            } else {// custom view
                //Log.d("plugin", "------custom view");
                view = LayoutInflater.from(context).createView(name, null, attrs);
            }
        } catch (Exception e) {
            view = null;
        }
        return view;
    }

    private void collectViewAttr(View view, Context context, AttributeSet attrs) {
        List<ResAttr> resAttrs = new ArrayList<>();
        int attCount = attrs.getAttributeCount();
        for (int i = 0; i < attCount; ++i) {
            String attributeName = attrs.getAttributeName(i);
            String attributeValue = attrs.getAttributeValue(i);
            //Log.d("plugin", "------attributeName/attributeValue = " + attributeName + "/" + attributeValue);
            if (isSupportedAttr(attributeName)) {
                //Log.d("plugin", "------is supported");
                if (attributeValue.startsWith("@")) {
                    //Log.d("plugin", "------startsWith @");
                    int resId = Integer.parseInt(attributeValue.substring(1));
                    //Log.d("plugin", "------resId = " + resId);
                    if (resId > 0) {
                        try {
                            String resName = context.getResources().getResourceEntryName(resId);
                            String attrType = context.getResources().getResourceTypeName(resId);
                            //Log.d("plugin", "------resName/attrType = " + resName + "/" + attrType);
                            resAttrs.add(new ResAttr(attributeName, attrType, resName, resId));
                        } catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }
        if (resAttrs.size() > 0) {
            ResItem resItem = new ResItem(view, resAttrs);
            // update now
            resItem.apply();
            resItems.add(resItem);
        }

    }

    private boolean isSupportedAttr(String attributeName) {
        return "text".equals(attributeName) || "title".equals(attributeName);
        //return "background".equals(attributeName) || "textColor".equals(attributeName) || "src".equals(attributeName);
    }

    public void apply() {
        if (null == resItems || 0 == resItems.size()) {
            return;
        }
        if (CommonPreference.getInstance().getBoolean("resource_need_update", false)) {
            CommonPreference.getInstance().putBoolean("resource_need_update", false);
            for (ResItem item : resItems) {
                item.apply();
            }
        }
    }

    public void clear() {
        resItems.clear();
    }
}
