package com.cv.media.lib.plugin;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;

import java.io.File;
import java.lang.reflect.Method;

import dalvik.system.DexClassLoader;

import com.cv.media.lib.common_utils.provider.ContextProvider;

import com.cv.media.lib.plugin.ResourceManager;

public class ResourcesEngine {

    private static final String TAG = "ResourcesEngine";
    private static Context mContext;
    private static String mPluginDir;
    private static ResourcesPlugin mPluginResources;

    public static void init(Application application) {
        mContext = application.getBaseContext();
        File dexDir = mContext.getDir("plugin", Context.MODE_PRIVATE);
        if (!dexDir.exists()) {
            dexDir.mkdir();
        }
        mPluginDir = dexDir.getAbsolutePath();

        if (new File(ContextCompat.getDataDir(mContext).getAbsolutePath() + ResourceManager.RES_PLUGIN_PATH).exists()) {
            mPluginResources = loadResource(ContextCompat.getDataDir(mContext).getAbsolutePath() + ResourceManager.RES_PLUGIN_PATH);
        }

        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks() {
            @Override
            public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
                MyResources myResources = new MyResources(mContext, activity.getResources(), mPluginResources);
                ReflectionUtils.setFieldValue(activity, "mResources", myResources);
            }

            @Override
            public void onActivityStarted(@NonNull Activity activity) {

            }

            @Override
            public void onActivityResumed(@NonNull Activity activity) {

            }

            @Override
            public void onActivityPaused(@NonNull Activity activity) {

            }

            @Override
            public void onActivityStopped(@NonNull Activity activity) {

            }

            @Override
            public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {

            }

            @Override
            public void onActivityDestroyed(@NonNull Activity activity) {

            }
        });
    }

    /**
     * 加载未安装应用资源包
     *
     * @param resourcePath
     * @return
     */
    private static ResourcesPlugin loadResource(String resourcePath) {
        ResourcesPlugin loadResource = null;
        PackageInfo info = queryPackageInfo(resourcePath);//获取未安装APK的PackageInfo
        if (info != null) {//获取成功
            try {
                AssetManager assetManager = AssetManager.class.newInstance();//创建AssetManager实例
                Class cls = AssetManager.class;
                Method method = cls.getMethod("addAssetPath", String.class);
                method.invoke(assetManager, resourcePath);//反射设置资源加载路径
                Resources resources = new Resources(assetManager, mContext.getResources().getDisplayMetrics(),
                        mContext.getResources().getConfiguration());//构造出正确的Resource
                loadResource = new ResourcesPlugin();
                loadResource.resources = resources;
                loadResource.packageName = info.packageName;
                loadResource.classLoader = new DexClassLoader(resourcePath, mPluginDir, null, mContext.getClassLoader());//设置正确的类加载器, 因为需要去加载R文件
                Log.w(TAG, "build resource:" + resourcePath);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        Log.w(TAG, "load resource:" + resourcePath);
        return loadResource;
    }

    /**
     * 获取未安装应用PackageInfo
     *
     * @param resourcePath
     * @return
     */
    private static PackageInfo queryPackageInfo(String resourcePath) {
        return mContext.getPackageManager().getPackageArchiveInfo(resourcePath, PackageManager.GET_ACTIVITIES);
    }
}
